package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  MonitorId,
  IamRoleArn,
  UpdatedBy,
  Subdomain,
  CreatedAt,
  Url,
  IdentityCenterApplicationArn,
  CreatedBy,
  UpdatedAt,
  IdentityCenterInstanceArn,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class MonitorSummary(
    monitorId: MonitorId,
    displayName: ResourceName,
    subdomain: Subdomain,
    url: Url,
    roleArn: IamRoleArn,
    identityCenterInstanceArn: IdentityCenterInstanceArn,
    identityCenterApplicationArn: IdentityCenterApplicationArn,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.MonitorSummary = {
    import MonitorSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.MonitorSummary
      .builder()
      .monitorId(MonitorId.unwrap(monitorId): java.lang.String)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .subdomain(Subdomain.unwrap(subdomain): java.lang.String)
      .url(Url.unwrap(url): java.lang.String)
      .roleArn(IamRoleArn.unwrap(roleArn): java.lang.String)
      .identityCenterInstanceArn(
        IdentityCenterInstanceArn.unwrap(
          identityCenterInstanceArn
        ): java.lang.String
      )
      .identityCenterApplicationArn(
        IdentityCenterApplicationArn.unwrap(
          identityCenterApplicationArn
        ): java.lang.String
      )
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.MonitorSummary.ReadOnly =
    zio.aws.deadline.model.MonitorSummary.wrap(buildAwsValue())
}
object MonitorSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.MonitorSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.MonitorSummary =
      zio.aws.deadline.model.MonitorSummary(
        monitorId,
        displayName,
        subdomain,
        url,
        roleArn,
        identityCenterInstanceArn,
        identityCenterApplicationArn,
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def monitorId: MonitorId
    def displayName: ResourceName
    def subdomain: Subdomain
    def url: Url
    def roleArn: IamRoleArn
    def identityCenterInstanceArn: IdentityCenterInstanceArn
    def identityCenterApplicationArn: IdentityCenterApplicationArn
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getMonitorId: ZIO[Any, Nothing, MonitorId] = ZIO.succeed(monitorId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getSubdomain: ZIO[Any, Nothing, Subdomain] = ZIO.succeed(subdomain)
    def getUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(url)
    def getRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(roleArn)
    def getIdentityCenterInstanceArn
        : ZIO[Any, Nothing, IdentityCenterInstanceArn] =
      ZIO.succeed(identityCenterInstanceArn)
    def getIdentityCenterApplicationArn
        : ZIO[Any, Nothing, IdentityCenterApplicationArn] =
      ZIO.succeed(identityCenterApplicationArn)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.MonitorSummary
  ) extends zio.aws.deadline.model.MonitorSummary.ReadOnly {
    override val monitorId: MonitorId =
      zio.aws.deadline.model.primitives.MonitorId(impl.monitorId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val subdomain: Subdomain =
      zio.aws.deadline.model.primitives.Subdomain(impl.subdomain())
    override val url: Url = zio.aws.deadline.model.primitives.Url(impl.url())
    override val roleArn: IamRoleArn =
      zio.aws.deadline.model.primitives.IamRoleArn(impl.roleArn())
    override val identityCenterInstanceArn: IdentityCenterInstanceArn =
      zio.aws.deadline.model.primitives
        .IdentityCenterInstanceArn(impl.identityCenterInstanceArn())
    override val identityCenterApplicationArn: IdentityCenterApplicationArn =
      zio.aws.deadline.model.primitives
        .IdentityCenterApplicationArn(impl.identityCenterApplicationArn())
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.MonitorSummary
  ): zio.aws.deadline.model.MonitorSummary.ReadOnly = new Wrapper(impl)
}
