package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.ParameterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ParameterFilterExpression(
    name: String,
    operator: zio.aws.deadline.model.ComparisonOperator,
    value: ParameterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ParameterFilterExpression = {
    import ParameterFilterExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ParameterFilterExpression
      .builder()
      .name(name: java.lang.String)
      .operator(operator.unwrap)
      .value(ParameterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ParameterFilterExpression.ReadOnly =
    zio.aws.deadline.model.ParameterFilterExpression.wrap(buildAwsValue())
}
object ParameterFilterExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ParameterFilterExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ParameterFilterExpression =
      zio.aws.deadline.model.ParameterFilterExpression(name, operator, value)
    def name: String
    def operator: zio.aws.deadline.model.ComparisonOperator
    def value: ParameterValue
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.deadline.model.ComparisonOperator] =
      ZIO.succeed(operator)
    def getValue: ZIO[Any, Nothing, ParameterValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ParameterFilterExpression
  ) extends zio.aws.deadline.model.ParameterFilterExpression.ReadOnly {
    override val name: String = impl.name(): String
    override val operator: zio.aws.deadline.model.ComparisonOperator =
      zio.aws.deadline.model.ComparisonOperator.wrap(impl.operator())
    override val value: ParameterValue =
      zio.aws.deadline.model.primitives.ParameterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ParameterFilterExpression
  ): zio.aws.deadline.model.ParameterFilterExpression.ReadOnly = new Wrapper(
    impl
  )
}
