package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ParameterSortExpression(
    sortOrder: zio.aws.deadline.model.SortOrder,
    name: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ParameterSortExpression = {
    import ParameterSortExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ParameterSortExpression
      .builder()
      .sortOrder(sortOrder.unwrap)
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ParameterSortExpression.ReadOnly =
    zio.aws.deadline.model.ParameterSortExpression.wrap(buildAwsValue())
}
object ParameterSortExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ParameterSortExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ParameterSortExpression =
      zio.aws.deadline.model.ParameterSortExpression(sortOrder, name)
    def sortOrder: zio.aws.deadline.model.SortOrder
    def name: String
    def getSortOrder: ZIO[Any, Nothing, zio.aws.deadline.model.SortOrder] =
      ZIO.succeed(sortOrder)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ParameterSortExpression
  ) extends zio.aws.deadline.model.ParameterSortExpression.ReadOnly {
    override val sortOrder: zio.aws.deadline.model.SortOrder =
      zio.aws.deadline.model.SortOrder.wrap(impl.sortOrder())
    override val name: String = impl.name(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ParameterSortExpression
  ): zio.aws.deadline.model.ParameterSortExpression.ReadOnly = new Wrapper(impl)
}
