package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.CombinationExpression
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParameterSpace(
    parameters: Iterable[zio.aws.deadline.model.StepParameter],
    combination: Optional[CombinationExpression] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ParameterSpace = {
    import ParameterSpace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ParameterSpace
      .builder()
      .parameters(parameters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        combination.map(value =>
          CombinationExpression.unwrap(value): java.lang.String
        )
      )(_.combination)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ParameterSpace.ReadOnly =
    zio.aws.deadline.model.ParameterSpace.wrap(buildAwsValue())
}
object ParameterSpace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ParameterSpace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ParameterSpace =
      zio.aws.deadline.model.ParameterSpace(
        parameters.map { item =>
          item.asEditable
        },
        combination.map(value => value)
      )
    def parameters: List[zio.aws.deadline.model.StepParameter.ReadOnly]
    def combination: Optional[CombinationExpression]
    def getParameters: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.StepParameter.ReadOnly
    ]] = ZIO.succeed(parameters)
    def getCombination: ZIO[Any, AwsError, CombinationExpression] =
      AwsError.unwrapOptionField("combination", combination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ParameterSpace
  ) extends zio.aws.deadline.model.ParameterSpace.ReadOnly {
    override val parameters
        : List[zio.aws.deadline.model.StepParameter.ReadOnly] = impl
      .parameters()
      .asScala
      .map { item =>
        zio.aws.deadline.model.StepParameter.wrap(item)
      }
      .toList
    override val combination: Optional[CombinationExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.combination())
        .map(value =>
          zio.aws.deadline.model.primitives.CombinationExpression(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ParameterSpace
  ): zio.aws.deadline.model.ParameterSpace.ReadOnly = new Wrapper(impl)
}
