package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait PathFormat {
  def unwrap: software.amazon.awssdk.services.deadline.model.PathFormat
}
object PathFormat {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.PathFormat
  ): zio.aws.deadline.model.PathFormat = value match {
    case software.amazon.awssdk.services.deadline.model.PathFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.PathFormat.WINDOWS =>
      val r = windows
      r
    case software.amazon.awssdk.services.deadline.model.PathFormat.POSIX =>
      val r = posix
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.PathFormat {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.PathFormat =
      software.amazon.awssdk.services.deadline.model.PathFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object windows extends zio.aws.deadline.model.PathFormat {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.PathFormat =
      software.amazon.awssdk.services.deadline.model.PathFormat.WINDOWS
  }
  case object posix extends zio.aws.deadline.model.PathFormat {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.PathFormat =
      software.amazon.awssdk.services.deadline.model.PathFormat.POSIX
  }
}
