package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PathMappingRule(
    sourcePathFormat: zio.aws.deadline.model.PathFormat,
    sourcePath: String,
    destinationPath: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.PathMappingRule = {
    import PathMappingRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.PathMappingRule
      .builder()
      .sourcePathFormat(sourcePathFormat.unwrap)
      .sourcePath(sourcePath: java.lang.String)
      .destinationPath(destinationPath: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.PathMappingRule.ReadOnly =
    zio.aws.deadline.model.PathMappingRule.wrap(buildAwsValue())
}
object PathMappingRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.PathMappingRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.PathMappingRule =
      zio.aws.deadline.model
        .PathMappingRule(sourcePathFormat, sourcePath, destinationPath)
    def sourcePathFormat: zio.aws.deadline.model.PathFormat
    def sourcePath: String
    def destinationPath: String
    def getSourcePathFormat
        : ZIO[Any, Nothing, zio.aws.deadline.model.PathFormat] =
      ZIO.succeed(sourcePathFormat)
    def getSourcePath: ZIO[Any, Nothing, String] = ZIO.succeed(sourcePath)
    def getDestinationPath: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.PathMappingRule
  ) extends zio.aws.deadline.model.PathMappingRule.ReadOnly {
    override val sourcePathFormat: zio.aws.deadline.model.PathFormat =
      zio.aws.deadline.model.PathFormat.wrap(impl.sourcePathFormat())
    override val sourcePath: String = impl.sourcePath(): String
    override val destinationPath: String = impl.destinationPath(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.PathMappingRule
  ): zio.aws.deadline.model.PathMappingRule.ReadOnly = new Wrapper(impl)
}
