package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait Period {
  def unwrap: software.amazon.awssdk.services.deadline.model.Period
}
object Period {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.Period
  ): zio.aws.deadline.model.Period = value match {
    case software.amazon.awssdk.services.deadline.model.Period.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.Period.HOURLY =>
      val r = HOURLY
      r
    case software.amazon.awssdk.services.deadline.model.Period.DAILY =>
      val r = DAILY
      r
    case software.amazon.awssdk.services.deadline.model.Period.WEEKLY =>
      val r = WEEKLY
      r
    case software.amazon.awssdk.services.deadline.model.Period.MONTHLY =>
      val r = MONTHLY
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.Period {
    override def unwrap: software.amazon.awssdk.services.deadline.model.Period =
      software.amazon.awssdk.services.deadline.model.Period.UNKNOWN_TO_SDK_VERSION
  }
  case object HOURLY extends zio.aws.deadline.model.Period {
    override def unwrap: software.amazon.awssdk.services.deadline.model.Period =
      software.amazon.awssdk.services.deadline.model.Period.HOURLY
  }
  case object DAILY extends zio.aws.deadline.model.Period {
    override def unwrap: software.amazon.awssdk.services.deadline.model.Period =
      software.amazon.awssdk.services.deadline.model.Period.DAILY
  }
  case object WEEKLY extends zio.aws.deadline.model.Period {
    override def unwrap: software.amazon.awssdk.services.deadline.model.Period =
      software.amazon.awssdk.services.deadline.model.Period.WEEKLY
  }
  case object MONTHLY extends zio.aws.deadline.model.Period {
    override def unwrap: software.amazon.awssdk.services.deadline.model.Period =
      software.amazon.awssdk.services.deadline.model.Period.MONTHLY
  }
}
