package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  PosixUserGroupString,
  PosixUserUserString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PosixUser(
    user: PosixUserUserString,
    group: PosixUserGroupString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.PosixUser = {
    import PosixUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.PosixUser
      .builder()
      .user(PosixUserUserString.unwrap(user): java.lang.String)
      .group(PosixUserGroupString.unwrap(group): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.PosixUser.ReadOnly =
    zio.aws.deadline.model.PosixUser.wrap(buildAwsValue())
}
object PosixUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.PosixUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.PosixUser =
      zio.aws.deadline.model.PosixUser(user, group)
    def user: PosixUserUserString
    def group: PosixUserGroupString
    def getUser: ZIO[Any, Nothing, PosixUserUserString] = ZIO.succeed(user)
    def getGroup: ZIO[Any, Nothing, PosixUserGroupString] = ZIO.succeed(group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.PosixUser
  ) extends zio.aws.deadline.model.PosixUser.ReadOnly {
    override val user: PosixUserUserString =
      zio.aws.deadline.model.primitives.PosixUserUserString(impl.user())
    override val group: PosixUserGroupString =
      zio.aws.deadline.model.primitives.PosixUserGroupString(impl.group())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.PosixUser
  ): zio.aws.deadline.model.PosixUser.ReadOnly = new Wrapper(impl)
}
