package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait PrincipalType {
  def unwrap: software.amazon.awssdk.services.deadline.model.PrincipalType
}
object PrincipalType {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.PrincipalType
  ): zio.aws.deadline.model.PrincipalType = value match {
    case software.amazon.awssdk.services.deadline.model.PrincipalType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.PrincipalType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.deadline.model.PrincipalType.GROUP =>
      val r = GROUP
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.PrincipalType =
      software.amazon.awssdk.services.deadline.model.PrincipalType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.deadline.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.PrincipalType =
      software.amazon.awssdk.services.deadline.model.PrincipalType.USER
  }
  case object GROUP extends zio.aws.deadline.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.PrincipalType =
      software.amazon.awssdk.services.deadline.model.PrincipalType.GROUP
  }
}
