package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait QueueBlockedReason {
  def unwrap: software.amazon.awssdk.services.deadline.model.QueueBlockedReason
}
object QueueBlockedReason {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.QueueBlockedReason
  ): zio.aws.deadline.model.QueueBlockedReason = value match {
    case software.amazon.awssdk.services.deadline.model.QueueBlockedReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.QueueBlockedReason.NO_BUDGET_CONFIGURED =>
      val r = NO_BUDGET_CONFIGURED
      r
    case software.amazon.awssdk.services.deadline.model.QueueBlockedReason.BUDGET_THRESHOLD_REACHED =>
      val r = BUDGET_THRESHOLD_REACHED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.QueueBlockedReason {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.QueueBlockedReason =
      software.amazon.awssdk.services.deadline.model.QueueBlockedReason.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_BUDGET_CONFIGURED
      extends zio.aws.deadline.model.QueueBlockedReason {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.QueueBlockedReason =
      software.amazon.awssdk.services.deadline.model.QueueBlockedReason.NO_BUDGET_CONFIGURED
  }
  case object BUDGET_THRESHOLD_REACHED
      extends zio.aws.deadline.model.QueueBlockedReason {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.QueueBlockedReason =
      software.amazon.awssdk.services.deadline.model.QueueBlockedReason.BUDGET_THRESHOLD_REACHED
  }
}
