package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  Priority,
  EnvironmentName,
  QueueEnvironmentId
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class QueueEnvironmentSummary(
    queueEnvironmentId: QueueEnvironmentId,
    name: EnvironmentName,
    priority: Priority
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary = {
    import QueueEnvironmentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary
      .builder()
      .queueEnvironmentId(
        QueueEnvironmentId.unwrap(queueEnvironmentId): java.lang.String
      )
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .priority(Priority.unwrap(priority): Integer)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly =
    zio.aws.deadline.model.QueueEnvironmentSummary.wrap(buildAwsValue())
}
object QueueEnvironmentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.QueueEnvironmentSummary =
      zio.aws.deadline.model
        .QueueEnvironmentSummary(queueEnvironmentId, name, priority)
    def queueEnvironmentId: QueueEnvironmentId
    def name: EnvironmentName
    def priority: Priority
    def getQueueEnvironmentId: ZIO[Any, Nothing, QueueEnvironmentId] =
      ZIO.succeed(queueEnvironmentId)
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
    def getPriority: ZIO[Any, Nothing, Priority] = ZIO.succeed(priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary
  ) extends zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly {
    override val queueEnvironmentId: QueueEnvironmentId =
      zio.aws.deadline.model.primitives
        .QueueEnvironmentId(impl.queueEnvironmentId())
    override val name: EnvironmentName =
      zio.aws.deadline.model.primitives.EnvironmentName(impl.name())
    override val priority: Priority =
      zio.aws.deadline.model.primitives.Priority(impl.priority())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary
  ): zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly = new Wrapper(impl)
}
