package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  IdentityStoreId,
  IdentityCenterPrincipalId,
  QueueId,
  FarmId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class QueueMember(
    farmId: FarmId,
    queueId: QueueId,
    principalId: IdentityCenterPrincipalId,
    principalType: zio.aws.deadline.model.PrincipalType,
    identityStoreId: IdentityStoreId,
    membershipLevel: zio.aws.deadline.model.MembershipLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.QueueMember = {
    import QueueMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.QueueMember
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .principalId(
        IdentityCenterPrincipalId.unwrap(principalId): java.lang.String
      )
      .principalType(principalType.unwrap)
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .membershipLevel(membershipLevel.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.QueueMember.ReadOnly =
    zio.aws.deadline.model.QueueMember.wrap(buildAwsValue())
}
object QueueMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.QueueMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.QueueMember =
      zio.aws.deadline.model.QueueMember(
        farmId,
        queueId,
        principalId,
        principalType,
        identityStoreId,
        membershipLevel
      )
    def farmId: FarmId
    def queueId: QueueId
    def principalId: IdentityCenterPrincipalId
    def principalType: zio.aws.deadline.model.PrincipalType
    def identityStoreId: IdentityStoreId
    def membershipLevel: zio.aws.deadline.model.MembershipLevel
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getPrincipalId: ZIO[Any, Nothing, IdentityCenterPrincipalId] =
      ZIO.succeed(principalId)
    def getPrincipalType
        : ZIO[Any, Nothing, zio.aws.deadline.model.PrincipalType] =
      ZIO.succeed(principalType)
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getMembershipLevel
        : ZIO[Any, Nothing, zio.aws.deadline.model.MembershipLevel] =
      ZIO.succeed(membershipLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.QueueMember
  ) extends zio.aws.deadline.model.QueueMember.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val principalId: IdentityCenterPrincipalId =
      zio.aws.deadline.model.primitives
        .IdentityCenterPrincipalId(impl.principalId())
    override val principalType: zio.aws.deadline.model.PrincipalType =
      zio.aws.deadline.model.PrincipalType.wrap(impl.principalType())
    override val identityStoreId: IdentityStoreId =
      zio.aws.deadline.model.primitives.IdentityStoreId(impl.identityStoreId())
    override val membershipLevel: zio.aws.deadline.model.MembershipLevel =
      zio.aws.deadline.model.MembershipLevel.wrap(impl.membershipLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.QueueMember
  ): zio.aws.deadline.model.QueueMember.ReadOnly = new Wrapper(impl)
}
