package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait QueueStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.QueueStatus
}
object QueueStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.QueueStatus
  ): zio.aws.deadline.model.QueueStatus = value match {
    case software.amazon.awssdk.services.deadline.model.QueueStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.QueueStatus.IDLE =>
      val r = IDLE
      r
    case software.amazon.awssdk.services.deadline.model.QueueStatus.SCHEDULING =>
      val r = SCHEDULING
      r
    case software.amazon.awssdk.services.deadline.model.QueueStatus.SCHEDULING_BLOCKED =>
      val r = SCHEDULING_BLOCKED
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.QueueStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.QueueStatus =
      software.amazon.awssdk.services.deadline.model.QueueStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IDLE extends zio.aws.deadline.model.QueueStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.QueueStatus =
      software.amazon.awssdk.services.deadline.model.QueueStatus.IDLE
  }
  case object SCHEDULING extends zio.aws.deadline.model.QueueStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.QueueStatus =
      software.amazon.awssdk.services.deadline.model.QueueStatus.SCHEDULING
  }
  case object SCHEDULING_BLOCKED extends zio.aws.deadline.model.QueueStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.QueueStatus =
      software.amazon.awssdk.services.deadline.model.QueueStatus.SCHEDULING_BLOCKED
  }
}
