package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  QueueId,
  FarmId,
  UpdatedBy,
  CreatedAt,
  CreatedBy,
  UpdatedAt,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class QueueSummary(
    farmId: FarmId,
    queueId: QueueId,
    displayName: ResourceName,
    status: zio.aws.deadline.model.QueueStatus,
    defaultBudgetAction: zio.aws.deadline.model.DefaultQueueBudgetAction,
    blockedReason: Optional[zio.aws.deadline.model.QueueBlockedReason] =
      Optional.Absent,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.QueueSummary = {
    import QueueSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.QueueSummary
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .status(status.unwrap)
      .defaultBudgetAction(defaultBudgetAction.unwrap)
      .optionallyWith(blockedReason.map(value => value.unwrap))(_.blockedReason)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.QueueSummary.ReadOnly =
    zio.aws.deadline.model.QueueSummary.wrap(buildAwsValue())
}
object QueueSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.QueueSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.QueueSummary =
      zio.aws.deadline.model.QueueSummary(
        farmId,
        queueId,
        displayName,
        status,
        defaultBudgetAction,
        blockedReason.map(value => value),
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def farmId: FarmId
    def queueId: QueueId
    def displayName: ResourceName
    def status: zio.aws.deadline.model.QueueStatus
    def defaultBudgetAction: zio.aws.deadline.model.DefaultQueueBudgetAction
    def blockedReason: Optional[zio.aws.deadline.model.QueueBlockedReason]
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getStatus: ZIO[Any, Nothing, zio.aws.deadline.model.QueueStatus] =
      ZIO.succeed(status)
    def getDefaultBudgetAction
        : ZIO[Any, Nothing, zio.aws.deadline.model.DefaultQueueBudgetAction] =
      ZIO.succeed(defaultBudgetAction)
    def getBlockedReason
        : ZIO[Any, AwsError, zio.aws.deadline.model.QueueBlockedReason] =
      AwsError.unwrapOptionField("blockedReason", blockedReason)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.QueueSummary
  ) extends zio.aws.deadline.model.QueueSummary.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val status: zio.aws.deadline.model.QueueStatus =
      zio.aws.deadline.model.QueueStatus.wrap(impl.status())
    override val defaultBudgetAction
        : zio.aws.deadline.model.DefaultQueueBudgetAction =
      zio.aws.deadline.model.DefaultQueueBudgetAction
        .wrap(impl.defaultBudgetAction())
    override val blockedReason
        : Optional[zio.aws.deadline.model.QueueBlockedReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockedReason())
        .map(value => zio.aws.deadline.model.QueueBlockedReason.wrap(value))
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.QueueSummary
  ): zio.aws.deadline.model.QueueSummary.ReadOnly = new Wrapper(impl)
}
