package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait RunAs {
  def unwrap: software.amazon.awssdk.services.deadline.model.RunAs
}
object RunAs {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.RunAs
  ): zio.aws.deadline.model.RunAs = value match {
    case software.amazon.awssdk.services.deadline.model.RunAs.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.RunAs.QUEUE_CONFIGURED_USER =>
      val r = QUEUE_CONFIGURED_USER
      r
    case software.amazon.awssdk.services.deadline.model.RunAs.WORKER_AGENT_USER =>
      val r = WORKER_AGENT_USER
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.RunAs {
    override def unwrap: software.amazon.awssdk.services.deadline.model.RunAs =
      software.amazon.awssdk.services.deadline.model.RunAs.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUE_CONFIGURED_USER extends zio.aws.deadline.model.RunAs {
    override def unwrap: software.amazon.awssdk.services.deadline.model.RunAs =
      software.amazon.awssdk.services.deadline.model.RunAs.QUEUE_CONFIGURED_USER
  }
  case object WORKER_AGENT_USER extends zio.aws.deadline.model.RunAs {
    override def unwrap: software.amazon.awssdk.services.deadline.model.RunAs =
      software.amazon.awssdk.services.deadline.model.RunAs.WORKER_AGENT_USER
  }
}
