package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{S3Key, S3BucketName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3Location(bucketName: S3BucketName, key: S3Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.S3Location
      .builder()
      .bucketName(S3BucketName.unwrap(bucketName): java.lang.String)
      .key(S3Key.unwrap(key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.S3Location.ReadOnly =
    zio.aws.deadline.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.S3Location =
      zio.aws.deadline.model.S3Location(bucketName, key)
    def bucketName: S3BucketName
    def key: S3Key
    def getBucketName: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucketName)
    def getKey: ZIO[Any, Nothing, S3Key] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.S3Location
  ) extends zio.aws.deadline.model.S3Location.ReadOnly {
    override val bucketName: S3BucketName =
      zio.aws.deadline.model.primitives.S3BucketName(impl.bucketName())
    override val key: S3Key =
      zio.aws.deadline.model.primitives.S3Key(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.S3Location
  ): zio.aws.deadline.model.S3Location.ReadOnly = new Wrapper(impl)
}
