package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchFilterExpression(
    dateTimeFilter: Optional[zio.aws.deadline.model.DateTimeFilterExpression] =
      Optional.Absent,
    parameterFilter: Optional[
      zio.aws.deadline.model.ParameterFilterExpression
    ] = Optional.Absent,
    searchTermFilter: Optional[
      zio.aws.deadline.model.SearchTermFilterExpression
    ] = Optional.Absent,
    stringFilter: Optional[zio.aws.deadline.model.StringFilterExpression] =
      Optional.Absent,
    groupFilter: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchFilterExpression = {
    import SearchFilterExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchFilterExpression
      .builder()
      .optionallyWith(dateTimeFilter.map(value => value.buildAwsValue()))(
        _.dateTimeFilter
      )
      .optionallyWith(parameterFilter.map(value => value.buildAwsValue()))(
        _.parameterFilter
      )
      .optionallyWith(searchTermFilter.map(value => value.buildAwsValue()))(
        _.searchTermFilter
      )
      .optionallyWith(stringFilter.map(value => value.buildAwsValue()))(
        _.stringFilter
      )
      .optionallyWith(groupFilter.map(value => value.buildAwsValue()))(
        _.groupFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SearchFilterExpression.ReadOnly =
    zio.aws.deadline.model.SearchFilterExpression.wrap(buildAwsValue())
}
object SearchFilterExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchFilterExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchFilterExpression =
      zio.aws.deadline.model.SearchFilterExpression(
        dateTimeFilter.map(value => value.asEditable),
        parameterFilter.map(value => value.asEditable),
        searchTermFilter.map(value => value.asEditable),
        stringFilter.map(value => value.asEditable),
        groupFilter.map(value => value.asEditable)
      )
    def dateTimeFilter
        : Optional[zio.aws.deadline.model.DateTimeFilterExpression.ReadOnly]
    def parameterFilter
        : Optional[zio.aws.deadline.model.ParameterFilterExpression.ReadOnly]
    def searchTermFilter
        : Optional[zio.aws.deadline.model.SearchTermFilterExpression.ReadOnly]
    def stringFilter
        : Optional[zio.aws.deadline.model.StringFilterExpression.ReadOnly]
    def groupFilter: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ]
    def getDateTimeFilter: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.DateTimeFilterExpression.ReadOnly
    ] = AwsError.unwrapOptionField("dateTimeFilter", dateTimeFilter)
    def getParameterFilter: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.ParameterFilterExpression.ReadOnly
    ] = AwsError.unwrapOptionField("parameterFilter", parameterFilter)
    def getSearchTermFilter: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.SearchTermFilterExpression.ReadOnly
    ] = AwsError.unwrapOptionField("searchTermFilter", searchTermFilter)
    def getStringFilter: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.StringFilterExpression.ReadOnly
    ] = AwsError.unwrapOptionField("stringFilter", stringFilter)
    def getGroupFilter: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ] = AwsError.unwrapOptionField("groupFilter", groupFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchFilterExpression
  ) extends zio.aws.deadline.model.SearchFilterExpression.ReadOnly {
    override val dateTimeFilter
        : Optional[zio.aws.deadline.model.DateTimeFilterExpression.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dateTimeFilter())
        .map(value =>
          zio.aws.deadline.model.DateTimeFilterExpression.wrap(value)
        )
    override val parameterFilter
        : Optional[zio.aws.deadline.model.ParameterFilterExpression.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterFilter())
        .map(value =>
          zio.aws.deadline.model.ParameterFilterExpression.wrap(value)
        )
    override val searchTermFilter
        : Optional[zio.aws.deadline.model.SearchTermFilterExpression.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchTermFilter())
        .map(value =>
          zio.aws.deadline.model.SearchTermFilterExpression.wrap(value)
        )
    override val stringFilter
        : Optional[zio.aws.deadline.model.StringFilterExpression.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringFilter())
        .map(value => zio.aws.deadline.model.StringFilterExpression.wrap(value))
    override val groupFilter: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groupFilter())
      .map(value =>
        zio.aws.deadline.model.SearchGroupedFilterExpressions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchFilterExpression
  ): zio.aws.deadline.model.SearchFilterExpression.ReadOnly = new Wrapper(impl)
}
