package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SearchGroupedFilterExpressions(
    filters: Iterable[zio.aws.deadline.model.SearchFilterExpression],
    operator: zio.aws.deadline.model.LogicalOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchGroupedFilterExpressions = {
    import SearchGroupedFilterExpressions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchGroupedFilterExpressions
      .builder()
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly =
    zio.aws.deadline.model.SearchGroupedFilterExpressions.wrap(buildAwsValue())
}
object SearchGroupedFilterExpressions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchGroupedFilterExpressions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchGroupedFilterExpressions =
      zio.aws.deadline.model.SearchGroupedFilterExpressions(
        filters.map { item =>
          item.asEditable
        },
        operator
      )
    def filters: List[zio.aws.deadline.model.SearchFilterExpression.ReadOnly]
    def operator: zio.aws.deadline.model.LogicalOperator
    def getFilters: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.SearchFilterExpression.ReadOnly
    ]] = ZIO.succeed(filters)
    def getOperator: ZIO[Any, Nothing, zio.aws.deadline.model.LogicalOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchGroupedFilterExpressions
  ) extends zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly {
    override val filters
        : List[zio.aws.deadline.model.SearchFilterExpression.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.deadline.model.SearchFilterExpression.wrap(item)
      }
      .toList
    override val operator: zio.aws.deadline.model.LogicalOperator =
      zio.aws.deadline.model.LogicalOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchGroupedFilterExpressions
  ): zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly =
    new Wrapper(impl)
}
