package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  SearchJobsRequestPageSizeInteger,
  SearchJobsRequestItemOffsetInteger,
  QueueId,
  FarmId
}
import scala.jdk.CollectionConverters._
final case class SearchJobsRequest(
    farmId: FarmId,
    queueIds: Iterable[QueueId],
    filterExpressions: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions
    ] = Optional.Absent,
    sortExpressions: Optional[
      Iterable[zio.aws.deadline.model.SearchSortExpression]
    ] = Optional.Absent,
    itemOffset: SearchJobsRequestItemOffsetInteger,
    pageSize: Optional[SearchJobsRequestPageSizeInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchJobsRequest = {
    import SearchJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchJobsRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueIds(queueIds.map { item =>
        QueueId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(filterExpressions.map(value => value.buildAwsValue()))(
        _.filterExpressions
      )
      .optionallyWith(
        sortExpressions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortExpressions)
      .itemOffset(
        SearchJobsRequestItemOffsetInteger.unwrap(itemOffset): Integer
      )
      .optionallyWith(
        pageSize.map(value =>
          SearchJobsRequestPageSizeInteger.unwrap(value): Integer
        )
      )(_.pageSize)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SearchJobsRequest.ReadOnly =
    zio.aws.deadline.model.SearchJobsRequest.wrap(buildAwsValue())
}
object SearchJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchJobsRequest =
      zio.aws.deadline.model.SearchJobsRequest(
        farmId,
        queueIds,
        filterExpressions.map(value => value.asEditable),
        sortExpressions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        itemOffset,
        pageSize.map(value => value)
      )
    def farmId: FarmId
    def queueIds: List[QueueId]
    def filterExpressions: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ]
    def sortExpressions
        : Optional[List[zio.aws.deadline.model.SearchSortExpression.ReadOnly]]
    def itemOffset: SearchJobsRequestItemOffsetInteger
    def pageSize: Optional[SearchJobsRequestPageSizeInteger]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueIds: ZIO[Any, Nothing, List[QueueId]] = ZIO.succeed(queueIds)
    def getFilterExpressions: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ] = AwsError.unwrapOptionField("filterExpressions", filterExpressions)
    def getSortExpressions: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.SearchSortExpression.ReadOnly
    ]] = AwsError.unwrapOptionField("sortExpressions", sortExpressions)
    def getItemOffset: ZIO[Any, Nothing, SearchJobsRequestItemOffsetInteger] =
      ZIO.succeed(itemOffset)
    def getPageSize: ZIO[Any, AwsError, SearchJobsRequestPageSizeInteger] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchJobsRequest
  ) extends zio.aws.deadline.model.SearchJobsRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueIds: List[QueueId] = impl
      .queueIds()
      .asScala
      .map { item =>
        zio.aws.deadline.model.primitives.QueueId(item)
      }
      .toList
    override val filterExpressions: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filterExpressions())
      .map(value =>
        zio.aws.deadline.model.SearchGroupedFilterExpressions.wrap(value)
      )
    override val sortExpressions
        : Optional[List[zio.aws.deadline.model.SearchSortExpression.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortExpressions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.SearchSortExpression.wrap(item)
          }.toList
        )
    override val itemOffset: SearchJobsRequestItemOffsetInteger =
      zio.aws.deadline.model.primitives
        .SearchJobsRequestItemOffsetInteger(impl.itemOffset())
    override val pageSize: Optional[SearchJobsRequestPageSizeInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pageSize())
        .map(value =>
          zio.aws.deadline.model.primitives
            .SearchJobsRequestPageSizeInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchJobsRequest
  ): zio.aws.deadline.model.SearchJobsRequest.ReadOnly = new Wrapper(impl)
}
