package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{TotalResults, NextItemOffset}
import scala.jdk.CollectionConverters._
final case class SearchJobsResponse(
    jobs: Iterable[zio.aws.deadline.model.JobSearchSummary],
    nextItemOffset: Optional[NextItemOffset] = Optional.Absent,
    totalResults: TotalResults
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchJobsResponse = {
    import SearchJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchJobsResponse
      .builder()
      .jobs(jobs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextItemOffset.map(value => NextItemOffset.unwrap(value): Integer)
      )(_.nextItemOffset)
      .totalResults(TotalResults.unwrap(totalResults): Integer)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SearchJobsResponse.ReadOnly =
    zio.aws.deadline.model.SearchJobsResponse.wrap(buildAwsValue())
}
object SearchJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchJobsResponse =
      zio.aws.deadline.model.SearchJobsResponse(
        jobs.map { item =>
          item.asEditable
        },
        nextItemOffset.map(value => value),
        totalResults
      )
    def jobs: List[zio.aws.deadline.model.JobSearchSummary.ReadOnly]
    def nextItemOffset: Optional[NextItemOffset]
    def totalResults: TotalResults
    def getJobs: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.JobSearchSummary.ReadOnly
    ]] = ZIO.succeed(jobs)
    def getNextItemOffset: ZIO[Any, AwsError, NextItemOffset] =
      AwsError.unwrapOptionField("nextItemOffset", nextItemOffset)
    def getTotalResults: ZIO[Any, Nothing, TotalResults] =
      ZIO.succeed(totalResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchJobsResponse
  ) extends zio.aws.deadline.model.SearchJobsResponse.ReadOnly {
    override val jobs: List[zio.aws.deadline.model.JobSearchSummary.ReadOnly] =
      impl
        .jobs()
        .asScala
        .map { item =>
          zio.aws.deadline.model.JobSearchSummary.wrap(item)
        }
        .toList
    override val nextItemOffset: Optional[NextItemOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextItemOffset())
        .map(value => zio.aws.deadline.model.primitives.NextItemOffset(value))
    override val totalResults: TotalResults =
      zio.aws.deadline.model.primitives.TotalResults(impl.totalResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchJobsResponse
  ): zio.aws.deadline.model.SearchJobsResponse.ReadOnly = new Wrapper(impl)
}
