package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchSortExpression(
    userJobsFirst: Optional[zio.aws.deadline.model.UserJobsFirst] =
      Optional.Absent,
    fieldSort: Optional[zio.aws.deadline.model.FieldSortExpression] =
      Optional.Absent,
    parameterSort: Optional[zio.aws.deadline.model.ParameterSortExpression] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchSortExpression = {
    import SearchSortExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchSortExpression
      .builder()
      .optionallyWith(userJobsFirst.map(value => value.buildAwsValue()))(
        _.userJobsFirst
      )
      .optionallyWith(fieldSort.map(value => value.buildAwsValue()))(
        _.fieldSort
      )
      .optionallyWith(parameterSort.map(value => value.buildAwsValue()))(
        _.parameterSort
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SearchSortExpression.ReadOnly =
    zio.aws.deadline.model.SearchSortExpression.wrap(buildAwsValue())
}
object SearchSortExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchSortExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchSortExpression =
      zio.aws.deadline.model.SearchSortExpression(
        userJobsFirst.map(value => value.asEditable),
        fieldSort.map(value => value.asEditable),
        parameterSort.map(value => value.asEditable)
      )
    def userJobsFirst: Optional[zio.aws.deadline.model.UserJobsFirst.ReadOnly]
    def fieldSort: Optional[zio.aws.deadline.model.FieldSortExpression.ReadOnly]
    def parameterSort
        : Optional[zio.aws.deadline.model.ParameterSortExpression.ReadOnly]
    def getUserJobsFirst
        : ZIO[Any, AwsError, zio.aws.deadline.model.UserJobsFirst.ReadOnly] =
      AwsError.unwrapOptionField("userJobsFirst", userJobsFirst)
    def getFieldSort: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.FieldSortExpression.ReadOnly
    ] = AwsError.unwrapOptionField("fieldSort", fieldSort)
    def getParameterSort: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.ParameterSortExpression.ReadOnly
    ] = AwsError.unwrapOptionField("parameterSort", parameterSort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchSortExpression
  ) extends zio.aws.deadline.model.SearchSortExpression.ReadOnly {
    override val userJobsFirst
        : Optional[zio.aws.deadline.model.UserJobsFirst.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userJobsFirst())
        .map(value => zio.aws.deadline.model.UserJobsFirst.wrap(value))
    override val fieldSort
        : Optional[zio.aws.deadline.model.FieldSortExpression.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fieldSort())
        .map(value => zio.aws.deadline.model.FieldSortExpression.wrap(value))
    override val parameterSort
        : Optional[zio.aws.deadline.model.ParameterSortExpression.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterSort())
        .map(value =>
          zio.aws.deadline.model.ParameterSortExpression.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchSortExpression
  ): zio.aws.deadline.model.SearchSortExpression.ReadOnly = new Wrapper(impl)
}
