package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{TotalResults, NextItemOffset}
import scala.jdk.CollectionConverters._
final case class SearchStepsResponse(
    steps: Iterable[zio.aws.deadline.model.StepSearchSummary],
    nextItemOffset: Optional[NextItemOffset] = Optional.Absent,
    totalResults: TotalResults
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchStepsResponse = {
    import SearchStepsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchStepsResponse
      .builder()
      .steps(steps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextItemOffset.map(value => NextItemOffset.unwrap(value): Integer)
      )(_.nextItemOffset)
      .totalResults(TotalResults.unwrap(totalResults): Integer)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SearchStepsResponse.ReadOnly =
    zio.aws.deadline.model.SearchStepsResponse.wrap(buildAwsValue())
}
object SearchStepsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchStepsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchStepsResponse =
      zio.aws.deadline.model.SearchStepsResponse(
        steps.map { item =>
          item.asEditable
        },
        nextItemOffset.map(value => value),
        totalResults
      )
    def steps: List[zio.aws.deadline.model.StepSearchSummary.ReadOnly]
    def nextItemOffset: Optional[NextItemOffset]
    def totalResults: TotalResults
    def getSteps: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.StepSearchSummary.ReadOnly
    ]] = ZIO.succeed(steps)
    def getNextItemOffset: ZIO[Any, AwsError, NextItemOffset] =
      AwsError.unwrapOptionField("nextItemOffset", nextItemOffset)
    def getTotalResults: ZIO[Any, Nothing, TotalResults] =
      ZIO.succeed(totalResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchStepsResponse
  ) extends zio.aws.deadline.model.SearchStepsResponse.ReadOnly {
    override val steps
        : List[zio.aws.deadline.model.StepSearchSummary.ReadOnly] = impl
      .steps()
      .asScala
      .map { item =>
        zio.aws.deadline.model.StepSearchSummary.wrap(item)
      }
      .toList
    override val nextItemOffset: Optional[NextItemOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextItemOffset())
        .map(value => zio.aws.deadline.model.primitives.NextItemOffset(value))
    override val totalResults: TotalResults =
      zio.aws.deadline.model.primitives.TotalResults(impl.totalResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchStepsResponse
  ): zio.aws.deadline.model.SearchStepsResponse.ReadOnly = new Wrapper(impl)
}
