package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  QueueId,
  FarmId,
  SearchTasksRequestItemOffsetInteger,
  SearchTasksRequestPageSizeInteger,
  JobId
}
import scala.jdk.CollectionConverters._
final case class SearchTasksRequest(
    farmId: FarmId,
    queueIds: Iterable[QueueId],
    jobId: Optional[JobId] = Optional.Absent,
    filterExpressions: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions
    ] = Optional.Absent,
    sortExpressions: Optional[
      Iterable[zio.aws.deadline.model.SearchSortExpression]
    ] = Optional.Absent,
    itemOffset: SearchTasksRequestItemOffsetInteger,
    pageSize: Optional[SearchTasksRequestPageSizeInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchTasksRequest = {
    import SearchTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchTasksRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueIds(queueIds.map { item =>
        QueueId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(filterExpressions.map(value => value.buildAwsValue()))(
        _.filterExpressions
      )
      .optionallyWith(
        sortExpressions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortExpressions)
      .itemOffset(
        SearchTasksRequestItemOffsetInteger.unwrap(itemOffset): Integer
      )
      .optionallyWith(
        pageSize.map(value =>
          SearchTasksRequestPageSizeInteger.unwrap(value): Integer
        )
      )(_.pageSize)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SearchTasksRequest.ReadOnly =
    zio.aws.deadline.model.SearchTasksRequest.wrap(buildAwsValue())
}
object SearchTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchTasksRequest =
      zio.aws.deadline.model.SearchTasksRequest(
        farmId,
        queueIds,
        jobId.map(value => value),
        filterExpressions.map(value => value.asEditable),
        sortExpressions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        itemOffset,
        pageSize.map(value => value)
      )
    def farmId: FarmId
    def queueIds: List[QueueId]
    def jobId: Optional[JobId]
    def filterExpressions: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ]
    def sortExpressions
        : Optional[List[zio.aws.deadline.model.SearchSortExpression.ReadOnly]]
    def itemOffset: SearchTasksRequestItemOffsetInteger
    def pageSize: Optional[SearchTasksRequestPageSizeInteger]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueIds: ZIO[Any, Nothing, List[QueueId]] = ZIO.succeed(queueIds)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getFilterExpressions: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ] = AwsError.unwrapOptionField("filterExpressions", filterExpressions)
    def getSortExpressions: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.SearchSortExpression.ReadOnly
    ]] = AwsError.unwrapOptionField("sortExpressions", sortExpressions)
    def getItemOffset: ZIO[Any, Nothing, SearchTasksRequestItemOffsetInteger] =
      ZIO.succeed(itemOffset)
    def getPageSize: ZIO[Any, AwsError, SearchTasksRequestPageSizeInteger] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchTasksRequest
  ) extends zio.aws.deadline.model.SearchTasksRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueIds: List[QueueId] = impl
      .queueIds()
      .asScala
      .map { item =>
        zio.aws.deadline.model.primitives.QueueId(item)
      }
      .toList
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.deadline.model.primitives.JobId(value))
    override val filterExpressions: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filterExpressions())
      .map(value =>
        zio.aws.deadline.model.SearchGroupedFilterExpressions.wrap(value)
      )
    override val sortExpressions
        : Optional[List[zio.aws.deadline.model.SearchSortExpression.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortExpressions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.SearchSortExpression.wrap(item)
          }.toList
        )
    override val itemOffset: SearchTasksRequestItemOffsetInteger =
      zio.aws.deadline.model.primitives
        .SearchTasksRequestItemOffsetInteger(impl.itemOffset())
    override val pageSize: Optional[SearchTasksRequestPageSizeInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pageSize())
        .map(value =>
          zio.aws.deadline.model.primitives
            .SearchTasksRequestPageSizeInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchTasksRequest
  ): zio.aws.deadline.model.SearchTasksRequest.ReadOnly = new Wrapper(impl)
}
