package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{TotalResults, NextItemOffset}
import scala.jdk.CollectionConverters._
final case class SearchTasksResponse(
    tasks: Iterable[zio.aws.deadline.model.TaskSearchSummary],
    nextItemOffset: Optional[NextItemOffset] = Optional.Absent,
    totalResults: TotalResults
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchTasksResponse = {
    import SearchTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchTasksResponse
      .builder()
      .tasks(tasks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextItemOffset.map(value => NextItemOffset.unwrap(value): Integer)
      )(_.nextItemOffset)
      .totalResults(TotalResults.unwrap(totalResults): Integer)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SearchTasksResponse.ReadOnly =
    zio.aws.deadline.model.SearchTasksResponse.wrap(buildAwsValue())
}
object SearchTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchTasksResponse =
      zio.aws.deadline.model.SearchTasksResponse(
        tasks.map { item =>
          item.asEditable
        },
        nextItemOffset.map(value => value),
        totalResults
      )
    def tasks: List[zio.aws.deadline.model.TaskSearchSummary.ReadOnly]
    def nextItemOffset: Optional[NextItemOffset]
    def totalResults: TotalResults
    def getTasks: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.TaskSearchSummary.ReadOnly
    ]] = ZIO.succeed(tasks)
    def getNextItemOffset: ZIO[Any, AwsError, NextItemOffset] =
      AwsError.unwrapOptionField("nextItemOffset", nextItemOffset)
    def getTotalResults: ZIO[Any, Nothing, TotalResults] =
      ZIO.succeed(totalResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchTasksResponse
  ) extends zio.aws.deadline.model.SearchTasksResponse.ReadOnly {
    override val tasks
        : List[zio.aws.deadline.model.TaskSearchSummary.ReadOnly] = impl
      .tasks()
      .asScala
      .map { item =>
        zio.aws.deadline.model.TaskSearchSummary.wrap(item)
      }
      .toList
    override val nextItemOffset: Optional[NextItemOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextItemOffset())
        .map(value => zio.aws.deadline.model.primitives.NextItemOffset(value))
    override val totalResults: TotalResults =
      zio.aws.deadline.model.primitives.TotalResults(impl.totalResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchTasksResponse
  ): zio.aws.deadline.model.SearchTasksResponse.ReadOnly = new Wrapper(impl)
}
