package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.SearchTerm
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SearchTermFilterExpression(searchTerm: SearchTerm) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchTermFilterExpression = {
    import SearchTermFilterExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchTermFilterExpression
      .builder()
      .searchTerm(SearchTerm.unwrap(searchTerm): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SearchTermFilterExpression.ReadOnly =
    zio.aws.deadline.model.SearchTermFilterExpression.wrap(buildAwsValue())
}
object SearchTermFilterExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchTermFilterExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchTermFilterExpression =
      zio.aws.deadline.model.SearchTermFilterExpression(searchTerm)
    def searchTerm: SearchTerm
    def getSearchTerm: ZIO[Any, Nothing, SearchTerm] = ZIO.succeed(searchTerm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchTermFilterExpression
  ) extends zio.aws.deadline.model.SearchTermFilterExpression.ReadOnly {
    override val searchTerm: SearchTerm =
      zio.aws.deadline.model.primitives.SearchTerm(impl.searchTerm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchTermFilterExpression
  ): zio.aws.deadline.model.SearchTermFilterExpression.ReadOnly = new Wrapper(
    impl
  )
}
