package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  SearchWorkersRequestPageSizeInteger,
  SearchWorkersRequestItemOffsetInteger,
  FleetId,
  FarmId
}
import scala.jdk.CollectionConverters._
final case class SearchWorkersRequest(
    farmId: FarmId,
    fleetIds: Iterable[FleetId],
    filterExpressions: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions
    ] = Optional.Absent,
    sortExpressions: Optional[
      Iterable[zio.aws.deadline.model.SearchSortExpression]
    ] = Optional.Absent,
    itemOffset: SearchWorkersRequestItemOffsetInteger,
    pageSize: Optional[SearchWorkersRequestPageSizeInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchWorkersRequest = {
    import SearchWorkersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchWorkersRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetIds(fleetIds.map { item =>
        FleetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(filterExpressions.map(value => value.buildAwsValue()))(
        _.filterExpressions
      )
      .optionallyWith(
        sortExpressions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortExpressions)
      .itemOffset(
        SearchWorkersRequestItemOffsetInteger.unwrap(itemOffset): Integer
      )
      .optionallyWith(
        pageSize.map(value =>
          SearchWorkersRequestPageSizeInteger.unwrap(value): Integer
        )
      )(_.pageSize)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SearchWorkersRequest.ReadOnly =
    zio.aws.deadline.model.SearchWorkersRequest.wrap(buildAwsValue())
}
object SearchWorkersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchWorkersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchWorkersRequest =
      zio.aws.deadline.model.SearchWorkersRequest(
        farmId,
        fleetIds,
        filterExpressions.map(value => value.asEditable),
        sortExpressions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        itemOffset,
        pageSize.map(value => value)
      )
    def farmId: FarmId
    def fleetIds: List[FleetId]
    def filterExpressions: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ]
    def sortExpressions
        : Optional[List[zio.aws.deadline.model.SearchSortExpression.ReadOnly]]
    def itemOffset: SearchWorkersRequestItemOffsetInteger
    def pageSize: Optional[SearchWorkersRequestPageSizeInteger]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetIds: ZIO[Any, Nothing, List[FleetId]] = ZIO.succeed(fleetIds)
    def getFilterExpressions: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ] = AwsError.unwrapOptionField("filterExpressions", filterExpressions)
    def getSortExpressions: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.SearchSortExpression.ReadOnly
    ]] = AwsError.unwrapOptionField("sortExpressions", sortExpressions)
    def getItemOffset
        : ZIO[Any, Nothing, SearchWorkersRequestItemOffsetInteger] =
      ZIO.succeed(itemOffset)
    def getPageSize: ZIO[Any, AwsError, SearchWorkersRequestPageSizeInteger] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchWorkersRequest
  ) extends zio.aws.deadline.model.SearchWorkersRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetIds: List[FleetId] = impl
      .fleetIds()
      .asScala
      .map { item =>
        zio.aws.deadline.model.primitives.FleetId(item)
      }
      .toList
    override val filterExpressions: Optional[
      zio.aws.deadline.model.SearchGroupedFilterExpressions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filterExpressions())
      .map(value =>
        zio.aws.deadline.model.SearchGroupedFilterExpressions.wrap(value)
      )
    override val sortExpressions
        : Optional[List[zio.aws.deadline.model.SearchSortExpression.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortExpressions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.SearchSortExpression.wrap(item)
          }.toList
        )
    override val itemOffset: SearchWorkersRequestItemOffsetInteger =
      zio.aws.deadline.model.primitives
        .SearchWorkersRequestItemOffsetInteger(impl.itemOffset())
    override val pageSize: Optional[SearchWorkersRequestPageSizeInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pageSize())
        .map(value =>
          zio.aws.deadline.model.primitives
            .SearchWorkersRequestPageSizeInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchWorkersRequest
  ): zio.aws.deadline.model.SearchWorkersRequest.ReadOnly = new Wrapper(impl)
}
