package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{TotalResults, NextItemOffset}
import scala.jdk.CollectionConverters._
final case class SearchWorkersResponse(
    workers: Iterable[zio.aws.deadline.model.WorkerSearchSummary],
    nextItemOffset: Optional[NextItemOffset] = Optional.Absent,
    totalResults: TotalResults
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SearchWorkersResponse = {
    import SearchWorkersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SearchWorkersResponse
      .builder()
      .workers(workers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextItemOffset.map(value => NextItemOffset.unwrap(value): Integer)
      )(_.nextItemOffset)
      .totalResults(TotalResults.unwrap(totalResults): Integer)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SearchWorkersResponse.ReadOnly =
    zio.aws.deadline.model.SearchWorkersResponse.wrap(buildAwsValue())
}
object SearchWorkersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SearchWorkersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SearchWorkersResponse =
      zio.aws.deadline.model.SearchWorkersResponse(
        workers.map { item =>
          item.asEditable
        },
        nextItemOffset.map(value => value),
        totalResults
      )
    def workers: List[zio.aws.deadline.model.WorkerSearchSummary.ReadOnly]
    def nextItemOffset: Optional[NextItemOffset]
    def totalResults: TotalResults
    def getWorkers: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.WorkerSearchSummary.ReadOnly
    ]] = ZIO.succeed(workers)
    def getNextItemOffset: ZIO[Any, AwsError, NextItemOffset] =
      AwsError.unwrapOptionField("nextItemOffset", nextItemOffset)
    def getTotalResults: ZIO[Any, Nothing, TotalResults] =
      ZIO.succeed(totalResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SearchWorkersResponse
  ) extends zio.aws.deadline.model.SearchWorkersResponse.ReadOnly {
    override val workers
        : List[zio.aws.deadline.model.WorkerSearchSummary.ReadOnly] = impl
      .workers()
      .asScala
      .map { item =>
        zio.aws.deadline.model.WorkerSearchSummary.wrap(item)
      }
      .toList
    override val nextItemOffset: Optional[NextItemOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextItemOffset())
        .map(value => zio.aws.deadline.model.primitives.NextItemOffset(value))
    override val totalResults: TotalResults =
      zio.aws.deadline.model.primitives.TotalResults(impl.totalResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SearchWorkersResponse
  ): zio.aws.deadline.model.SearchWorkersResponse.ReadOnly = new Wrapper(impl)
}
