package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ServiceManagedEc2FleetConfiguration(
    instanceCapabilities: zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities,
    instanceMarketOptions: zio.aws.deadline.model.ServiceManagedEc2InstanceMarketOptions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ServiceManagedEc2FleetConfiguration = {
    import ServiceManagedEc2FleetConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ServiceManagedEc2FleetConfiguration
      .builder()
      .instanceCapabilities(instanceCapabilities.buildAwsValue())
      .instanceMarketOptions(instanceMarketOptions.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration.ReadOnly =
    zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration
      .wrap(buildAwsValue())
}
object ServiceManagedEc2FleetConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ServiceManagedEc2FleetConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration =
      zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration(
        instanceCapabilities.asEditable,
        instanceMarketOptions.asEditable
      )
    def instanceCapabilities
        : zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities.ReadOnly
    def instanceMarketOptions
        : zio.aws.deadline.model.ServiceManagedEc2InstanceMarketOptions.ReadOnly
    def getInstanceCapabilities: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities.ReadOnly
    ] = ZIO.succeed(instanceCapabilities)
    def getInstanceMarketOptions: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.ServiceManagedEc2InstanceMarketOptions.ReadOnly
    ] = ZIO.succeed(instanceMarketOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ServiceManagedEc2FleetConfiguration
  ) extends zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration.ReadOnly {
    override val instanceCapabilities
        : zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities.ReadOnly =
      zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities
        .wrap(impl.instanceCapabilities())
    override val instanceMarketOptions
        : zio.aws.deadline.model.ServiceManagedEc2InstanceMarketOptions.ReadOnly =
      zio.aws.deadline.model.ServiceManagedEc2InstanceMarketOptions
        .wrap(impl.instanceMarketOptions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ServiceManagedEc2FleetConfiguration
  ): zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration.ReadOnly =
    new Wrapper(impl)
}
