package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.InstanceType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceManagedEc2InstanceCapabilities(
    vCpuCount: zio.aws.deadline.model.VCpuCountRange,
    memoryMiB: zio.aws.deadline.model.MemoryMiBRange,
    osFamily: zio.aws.deadline.model.ServiceManagedFleetOperatingSystemFamily,
    cpuArchitectureType: zio.aws.deadline.model.CpuArchitectureType,
    rootEbsVolume: Optional[zio.aws.deadline.model.Ec2EbsVolume] =
      Optional.Absent,
    allowedInstanceTypes: Optional[Iterable[InstanceType]] = Optional.Absent,
    excludedInstanceTypes: Optional[Iterable[InstanceType]] = Optional.Absent,
    customAmounts: Optional[
      Iterable[zio.aws.deadline.model.FleetAmountCapability]
    ] = Optional.Absent,
    customAttributes: Optional[
      Iterable[zio.aws.deadline.model.FleetAttributeCapability]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ServiceManagedEc2InstanceCapabilities = {
    import ServiceManagedEc2InstanceCapabilities.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ServiceManagedEc2InstanceCapabilities
      .builder()
      .vCpuCount(vCpuCount.buildAwsValue())
      .memoryMiB(memoryMiB.buildAwsValue())
      .osFamily(osFamily.unwrap)
      .cpuArchitectureType(cpuArchitectureType.unwrap)
      .optionallyWith(rootEbsVolume.map(value => value.buildAwsValue()))(
        _.rootEbsVolume
      )
      .optionallyWith(
        allowedInstanceTypes.map(value =>
          value.map { item =>
            InstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedInstanceTypes)
      .optionallyWith(
        excludedInstanceTypes.map(value =>
          value.map { item =>
            InstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedInstanceTypes)
      .optionallyWith(
        customAmounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customAmounts)
      .optionallyWith(
        customAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities.ReadOnly =
    zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities
      .wrap(buildAwsValue())
}
object ServiceManagedEc2InstanceCapabilities {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ServiceManagedEc2InstanceCapabilities
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities =
      zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities(
        vCpuCount.asEditable,
        memoryMiB.asEditable,
        osFamily,
        cpuArchitectureType,
        rootEbsVolume.map(value => value.asEditable),
        allowedInstanceTypes.map(value => value),
        excludedInstanceTypes.map(value => value),
        customAmounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vCpuCount: zio.aws.deadline.model.VCpuCountRange.ReadOnly
    def memoryMiB: zio.aws.deadline.model.MemoryMiBRange.ReadOnly
    def osFamily
        : zio.aws.deadline.model.ServiceManagedFleetOperatingSystemFamily
    def cpuArchitectureType: zio.aws.deadline.model.CpuArchitectureType
    def rootEbsVolume: Optional[zio.aws.deadline.model.Ec2EbsVolume.ReadOnly]
    def allowedInstanceTypes: Optional[List[InstanceType]]
    def excludedInstanceTypes: Optional[List[InstanceType]]
    def customAmounts
        : Optional[List[zio.aws.deadline.model.FleetAmountCapability.ReadOnly]]
    def customAttributes: Optional[
      List[zio.aws.deadline.model.FleetAttributeCapability.ReadOnly]
    ]
    def getVCpuCount
        : ZIO[Any, Nothing, zio.aws.deadline.model.VCpuCountRange.ReadOnly] =
      ZIO.succeed(vCpuCount)
    def getMemoryMiB
        : ZIO[Any, Nothing, zio.aws.deadline.model.MemoryMiBRange.ReadOnly] =
      ZIO.succeed(memoryMiB)
    def getOsFamily: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.ServiceManagedFleetOperatingSystemFamily
    ] = ZIO.succeed(osFamily)
    def getCpuArchitectureType
        : ZIO[Any, Nothing, zio.aws.deadline.model.CpuArchitectureType] =
      ZIO.succeed(cpuArchitectureType)
    def getRootEbsVolume
        : ZIO[Any, AwsError, zio.aws.deadline.model.Ec2EbsVolume.ReadOnly] =
      AwsError.unwrapOptionField("rootEbsVolume", rootEbsVolume)
    def getAllowedInstanceTypes: ZIO[Any, AwsError, List[InstanceType]] =
      AwsError.unwrapOptionField("allowedInstanceTypes", allowedInstanceTypes)
    def getExcludedInstanceTypes: ZIO[Any, AwsError, List[InstanceType]] =
      AwsError.unwrapOptionField("excludedInstanceTypes", excludedInstanceTypes)
    def getCustomAmounts: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FleetAmountCapability.ReadOnly
    ]] = AwsError.unwrapOptionField("customAmounts", customAmounts)
    def getCustomAttributes: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FleetAttributeCapability.ReadOnly
    ]] = AwsError.unwrapOptionField("customAttributes", customAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ServiceManagedEc2InstanceCapabilities
  ) extends zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities.ReadOnly {
    override val vCpuCount: zio.aws.deadline.model.VCpuCountRange.ReadOnly =
      zio.aws.deadline.model.VCpuCountRange.wrap(impl.vCpuCount())
    override val memoryMiB: zio.aws.deadline.model.MemoryMiBRange.ReadOnly =
      zio.aws.deadline.model.MemoryMiBRange.wrap(impl.memoryMiB())
    override val osFamily
        : zio.aws.deadline.model.ServiceManagedFleetOperatingSystemFamily =
      zio.aws.deadline.model.ServiceManagedFleetOperatingSystemFamily
        .wrap(impl.osFamily())
    override val cpuArchitectureType
        : zio.aws.deadline.model.CpuArchitectureType =
      zio.aws.deadline.model.CpuArchitectureType
        .wrap(impl.cpuArchitectureType())
    override val rootEbsVolume
        : Optional[zio.aws.deadline.model.Ec2EbsVolume.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootEbsVolume())
        .map(value => zio.aws.deadline.model.Ec2EbsVolume.wrap(value))
    override val allowedInstanceTypes: Optional[List[InstanceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.primitives.InstanceType(item)
          }.toList
        )
    override val excludedInstanceTypes: Optional[List[InstanceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludedInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.primitives.InstanceType(item)
          }.toList
        )
    override val customAmounts: Optional[
      List[zio.aws.deadline.model.FleetAmountCapability.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customAmounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.FleetAmountCapability.wrap(item)
        }.toList
      )
    override val customAttributes: Optional[
      List[zio.aws.deadline.model.FleetAttributeCapability.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.FleetAttributeCapability.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ServiceManagedEc2InstanceCapabilities
  ): zio.aws.deadline.model.ServiceManagedEc2InstanceCapabilities.ReadOnly =
    new Wrapper(impl)
}
