package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SessionActionDefinition(
    envEnter: Optional[
      zio.aws.deadline.model.EnvironmentEnterSessionActionDefinition
    ] = Optional.Absent,
    envExit: Optional[
      zio.aws.deadline.model.EnvironmentExitSessionActionDefinition
    ] = Optional.Absent,
    taskRun: Optional[zio.aws.deadline.model.TaskRunSessionActionDefinition] =
      Optional.Absent,
    syncInputJobAttachments: Optional[
      zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SessionActionDefinition = {
    import SessionActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SessionActionDefinition
      .builder()
      .optionallyWith(envEnter.map(value => value.buildAwsValue()))(_.envEnter)
      .optionallyWith(envExit.map(value => value.buildAwsValue()))(_.envExit)
      .optionallyWith(taskRun.map(value => value.buildAwsValue()))(_.taskRun)
      .optionallyWith(
        syncInputJobAttachments.map(value => value.buildAwsValue())
      )(_.syncInputJobAttachments)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SessionActionDefinition.ReadOnly =
    zio.aws.deadline.model.SessionActionDefinition.wrap(buildAwsValue())
}
object SessionActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SessionActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SessionActionDefinition =
      zio.aws.deadline.model.SessionActionDefinition(
        envEnter.map(value => value.asEditable),
        envExit.map(value => value.asEditable),
        taskRun.map(value => value.asEditable),
        syncInputJobAttachments.map(value => value.asEditable)
      )
    def envEnter: Optional[
      zio.aws.deadline.model.EnvironmentEnterSessionActionDefinition.ReadOnly
    ]
    def envExit: Optional[
      zio.aws.deadline.model.EnvironmentExitSessionActionDefinition.ReadOnly
    ]
    def taskRun: Optional[
      zio.aws.deadline.model.TaskRunSessionActionDefinition.ReadOnly
    ]
    def syncInputJobAttachments: Optional[
      zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition.ReadOnly
    ]
    def getEnvEnter: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.EnvironmentEnterSessionActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("envEnter", envEnter)
    def getEnvExit: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.EnvironmentExitSessionActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("envExit", envExit)
    def getTaskRun: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.TaskRunSessionActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("taskRun", taskRun)
    def getSyncInputJobAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "syncInputJobAttachments",
      syncInputJobAttachments
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SessionActionDefinition
  ) extends zio.aws.deadline.model.SessionActionDefinition.ReadOnly {
    override val envEnter: Optional[
      zio.aws.deadline.model.EnvironmentEnterSessionActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.envEnter())
      .map(value =>
        zio.aws.deadline.model.EnvironmentEnterSessionActionDefinition
          .wrap(value)
      )
    override val envExit: Optional[
      zio.aws.deadline.model.EnvironmentExitSessionActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.envExit())
      .map(value =>
        zio.aws.deadline.model.EnvironmentExitSessionActionDefinition
          .wrap(value)
      )
    override val taskRun: Optional[
      zio.aws.deadline.model.TaskRunSessionActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskRun())
      .map(value =>
        zio.aws.deadline.model.TaskRunSessionActionDefinition.wrap(value)
      )
    override val syncInputJobAttachments: Optional[
      zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.syncInputJobAttachments())
      .map(value =>
        zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SessionActionDefinition
  ): zio.aws.deadline.model.SessionActionDefinition.ReadOnly = new Wrapper(impl)
}
