package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SessionActionDefinitionSummary(
    envEnter: Optional[
      zio.aws.deadline.model.EnvironmentEnterSessionActionDefinitionSummary
    ] = Optional.Absent,
    envExit: Optional[
      zio.aws.deadline.model.EnvironmentExitSessionActionDefinitionSummary
    ] = Optional.Absent,
    taskRun: Optional[
      zio.aws.deadline.model.TaskRunSessionActionDefinitionSummary
    ] = Optional.Absent,
    syncInputJobAttachments: Optional[
      zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SessionActionDefinitionSummary = {
    import SessionActionDefinitionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SessionActionDefinitionSummary
      .builder()
      .optionallyWith(envEnter.map(value => value.buildAwsValue()))(_.envEnter)
      .optionallyWith(envExit.map(value => value.buildAwsValue()))(_.envExit)
      .optionallyWith(taskRun.map(value => value.buildAwsValue()))(_.taskRun)
      .optionallyWith(
        syncInputJobAttachments.map(value => value.buildAwsValue())
      )(_.syncInputJobAttachments)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.SessionActionDefinitionSummary.ReadOnly =
    zio.aws.deadline.model.SessionActionDefinitionSummary.wrap(buildAwsValue())
}
object SessionActionDefinitionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SessionActionDefinitionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SessionActionDefinitionSummary =
      zio.aws.deadline.model.SessionActionDefinitionSummary(
        envEnter.map(value => value.asEditable),
        envExit.map(value => value.asEditable),
        taskRun.map(value => value.asEditable),
        syncInputJobAttachments.map(value => value.asEditable)
      )
    def envEnter: Optional[
      zio.aws.deadline.model.EnvironmentEnterSessionActionDefinitionSummary.ReadOnly
    ]
    def envExit: Optional[
      zio.aws.deadline.model.EnvironmentExitSessionActionDefinitionSummary.ReadOnly
    ]
    def taskRun: Optional[
      zio.aws.deadline.model.TaskRunSessionActionDefinitionSummary.ReadOnly
    ]
    def syncInputJobAttachments: Optional[
      zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary.ReadOnly
    ]
    def getEnvEnter: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.EnvironmentEnterSessionActionDefinitionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("envEnter", envEnter)
    def getEnvExit: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.EnvironmentExitSessionActionDefinitionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("envExit", envExit)
    def getTaskRun: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.TaskRunSessionActionDefinitionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("taskRun", taskRun)
    def getSyncInputJobAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "syncInputJobAttachments",
      syncInputJobAttachments
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SessionActionDefinitionSummary
  ) extends zio.aws.deadline.model.SessionActionDefinitionSummary.ReadOnly {
    override val envEnter: Optional[
      zio.aws.deadline.model.EnvironmentEnterSessionActionDefinitionSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.envEnter())
      .map(value =>
        zio.aws.deadline.model.EnvironmentEnterSessionActionDefinitionSummary
          .wrap(value)
      )
    override val envExit: Optional[
      zio.aws.deadline.model.EnvironmentExitSessionActionDefinitionSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.envExit())
      .map(value =>
        zio.aws.deadline.model.EnvironmentExitSessionActionDefinitionSummary
          .wrap(value)
      )
    override val taskRun: Optional[
      zio.aws.deadline.model.TaskRunSessionActionDefinitionSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskRun())
      .map(value =>
        zio.aws.deadline.model.TaskRunSessionActionDefinitionSummary.wrap(value)
      )
    override val syncInputJobAttachments: Optional[
      zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.syncInputJobAttachments())
      .map(value =>
        zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SessionActionDefinitionSummary
  ): zio.aws.deadline.model.SessionActionDefinitionSummary.ReadOnly =
    new Wrapper(impl)
}
