package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait SessionActionStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.SessionActionStatus
}
object SessionActionStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.SessionActionStatus
  ): zio.aws.deadline.model.SessionActionStatus = value match {
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.ASSIGNED =>
      val r = ASSIGNED
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.CANCELING =>
      val r = CANCELING
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.INTERRUPTED =>
      val r = INTERRUPTED
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.NEVER_ATTEMPTED =>
      val r = NEVER_ATTEMPTED
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.SCHEDULED =>
      val r = SCHEDULED
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.RECLAIMING =>
      val r = RECLAIMING
      r
    case software.amazon.awssdk.services.deadline.model.SessionActionStatus.RECLAIMED =>
      val r = RECLAIMED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSIGNED extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.ASSIGNED
  }
  case object RUNNING extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.RUNNING
  }
  case object CANCELING extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.CANCELING
  }
  case object SUCCEEDED extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.FAILED
  }
  case object INTERRUPTED extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.INTERRUPTED
  }
  case object CANCELED extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.CANCELED
  }
  case object NEVER_ATTEMPTED
      extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.NEVER_ATTEMPTED
  }
  case object SCHEDULED extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.SCHEDULED
  }
  case object RECLAIMING extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.RECLAIMING
  }
  case object RECLAIMED extends zio.aws.deadline.model.SessionActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionActionStatus =
      software.amazon.awssdk.services.deadline.model.SessionActionStatus.RECLAIMED
  }
}
