package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  Timestamp,
  EndedAt,
  SessionActionProgressPercent,
  StartedAt,
  SessionActionId
}
import scala.jdk.CollectionConverters._
final case class SessionActionSummary(
    sessionActionId: SessionActionId,
    status: zio.aws.deadline.model.SessionActionStatus,
    startedAt: Optional[StartedAt] = Optional.Absent,
    endedAt: Optional[EndedAt] = Optional.Absent,
    workerUpdatedAt: Optional[Timestamp] = Optional.Absent,
    progressPercent: Optional[SessionActionProgressPercent] = Optional.Absent,
    definition: zio.aws.deadline.model.SessionActionDefinitionSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SessionActionSummary = {
    import SessionActionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SessionActionSummary
      .builder()
      .sessionActionId(
        SessionActionId.unwrap(sessionActionId): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(startedAt.map(value => StartedAt.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(endedAt.map(value => EndedAt.unwrap(value): Instant))(
        _.endedAt
      )
      .optionallyWith(
        workerUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.workerUpdatedAt)
      .optionallyWith(
        progressPercent.map(value =>
          SessionActionProgressPercent.unwrap(value): java.lang.Float
        )
      )(_.progressPercent)
      .definition(definition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SessionActionSummary.ReadOnly =
    zio.aws.deadline.model.SessionActionSummary.wrap(buildAwsValue())
}
object SessionActionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SessionActionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SessionActionSummary =
      zio.aws.deadline.model.SessionActionSummary(
        sessionActionId,
        status,
        startedAt.map(value => value),
        endedAt.map(value => value),
        workerUpdatedAt.map(value => value),
        progressPercent.map(value => value),
        definition.asEditable
      )
    def sessionActionId: SessionActionId
    def status: zio.aws.deadline.model.SessionActionStatus
    def startedAt: Optional[StartedAt]
    def endedAt: Optional[EndedAt]
    def workerUpdatedAt: Optional[Timestamp]
    def progressPercent: Optional[SessionActionProgressPercent]
    def definition
        : zio.aws.deadline.model.SessionActionDefinitionSummary.ReadOnly
    def getSessionActionId: ZIO[Any, Nothing, SessionActionId] =
      ZIO.succeed(sessionActionId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.deadline.model.SessionActionStatus] =
      ZIO.succeed(status)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getEndedAt: ZIO[Any, AwsError, EndedAt] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getWorkerUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("workerUpdatedAt", workerUpdatedAt)
    def getProgressPercent: ZIO[Any, AwsError, SessionActionProgressPercent] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
    def getDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.SessionActionDefinitionSummary.ReadOnly
    ] = ZIO.succeed(definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SessionActionSummary
  ) extends zio.aws.deadline.model.SessionActionSummary.ReadOnly {
    override val sessionActionId: SessionActionId =
      zio.aws.deadline.model.primitives.SessionActionId(impl.sessionActionId())
    override val status: zio.aws.deadline.model.SessionActionStatus =
      zio.aws.deadline.model.SessionActionStatus.wrap(impl.status())
    override val startedAt: Optional[StartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.deadline.model.primitives.StartedAt(value))
    override val endedAt: Optional[EndedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.deadline.model.primitives.EndedAt(value))
    override val workerUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.workerUpdatedAt())
      .map(value => zio.aws.deadline.model.primitives.Timestamp(value))
    override val progressPercent: Optional[SessionActionProgressPercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressPercent())
        .map(value =>
          zio.aws.deadline.model.primitives.SessionActionProgressPercent(value)
        )
    override val definition
        : zio.aws.deadline.model.SessionActionDefinitionSummary.ReadOnly =
      zio.aws.deadline.model.SessionActionDefinitionSummary
        .wrap(impl.definition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SessionActionSummary
  ): zio.aws.deadline.model.SessionActionSummary.ReadOnly = new Wrapper(impl)
}
