package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait SessionLifecycleStatus {
  def unwrap
      : software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus
}
object SessionLifecycleStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus
  ): zio.aws.deadline.model.SessionLifecycleStatus = value match {
    case software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.UPDATE_SUCCEEDED =>
      val r = UPDATE_SUCCEEDED
      r
    case software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.ENDED =>
      val r = ENDED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.SessionLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTED extends zio.aws.deadline.model.SessionLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.STARTED
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.deadline.model.SessionLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.UPDATE_IN_PROGRESS
  }
  case object UPDATE_SUCCEEDED
      extends zio.aws.deadline.model.SessionLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.UPDATE_SUCCEEDED
  }
  case object UPDATE_FAILED
      extends zio.aws.deadline.model.SessionLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.UPDATE_FAILED
  }
  case object ENDED extends zio.aws.deadline.model.SessionLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus.ENDED
  }
}
