package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  FleetId,
  UpdatedBy,
  WorkerId,
  EndedAt,
  StartedAt,
  UpdatedAt,
  SessionId
}
import scala.jdk.CollectionConverters._
final case class SessionSummary(
    sessionId: SessionId,
    fleetId: FleetId,
    workerId: WorkerId,
    startedAt: StartedAt,
    lifecycleStatus: zio.aws.deadline.model.SessionLifecycleStatus,
    endedAt: Optional[EndedAt] = Optional.Absent,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent,
    targetLifecycleStatus: Optional[
      zio.aws.deadline.model.SessionLifecycleTargetStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SessionSummary = {
    import SessionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SessionSummary
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .workerId(WorkerId.unwrap(workerId): java.lang.String)
      .startedAt(StartedAt.unwrap(startedAt): Instant)
      .lifecycleStatus(lifecycleStatus.unwrap)
      .optionallyWith(endedAt.map(value => EndedAt.unwrap(value): Instant))(
        _.endedAt
      )
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .optionallyWith(targetLifecycleStatus.map(value => value.unwrap))(
        _.targetLifecycleStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SessionSummary.ReadOnly =
    zio.aws.deadline.model.SessionSummary.wrap(buildAwsValue())
}
object SessionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SessionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SessionSummary =
      zio.aws.deadline.model.SessionSummary(
        sessionId,
        fleetId,
        workerId,
        startedAt,
        lifecycleStatus,
        endedAt.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value),
        targetLifecycleStatus.map(value => value)
      )
    def sessionId: SessionId
    def fleetId: FleetId
    def workerId: WorkerId
    def startedAt: StartedAt
    def lifecycleStatus: zio.aws.deadline.model.SessionLifecycleStatus
    def endedAt: Optional[EndedAt]
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def targetLifecycleStatus
        : Optional[zio.aws.deadline.model.SessionLifecycleTargetStatus]
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getWorkerId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(workerId)
    def getStartedAt: ZIO[Any, Nothing, StartedAt] = ZIO.succeed(startedAt)
    def getLifecycleStatus
        : ZIO[Any, Nothing, zio.aws.deadline.model.SessionLifecycleStatus] =
      ZIO.succeed(lifecycleStatus)
    def getEndedAt: ZIO[Any, AwsError, EndedAt] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getTargetLifecycleStatus: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.SessionLifecycleTargetStatus
    ] =
      AwsError.unwrapOptionField("targetLifecycleStatus", targetLifecycleStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SessionSummary
  ) extends zio.aws.deadline.model.SessionSummary.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.deadline.model.primitives.SessionId(impl.sessionId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val workerId: WorkerId =
      zio.aws.deadline.model.primitives.WorkerId(impl.workerId())
    override val startedAt: StartedAt =
      zio.aws.deadline.model.primitives.StartedAt(impl.startedAt())
    override val lifecycleStatus
        : zio.aws.deadline.model.SessionLifecycleStatus =
      zio.aws.deadline.model.SessionLifecycleStatus.wrap(impl.lifecycleStatus())
    override val endedAt: Optional[EndedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.deadline.model.primitives.EndedAt(value))
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
    override val targetLifecycleStatus
        : Optional[zio.aws.deadline.model.SessionLifecycleTargetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLifecycleStatus())
        .map(value =>
          zio.aws.deadline.model.SessionLifecycleTargetStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SessionSummary
  ): zio.aws.deadline.model.SessionSummary.ReadOnly = new Wrapper(impl)
}
