package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{FleetId, QueueId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SessionsStatisticsResources(
    queueIds: Optional[Iterable[QueueId]] = Optional.Absent,
    fleetIds: Optional[Iterable[FleetId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SessionsStatisticsResources = {
    import SessionsStatisticsResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SessionsStatisticsResources
      .builder()
      .optionallyWith(
        queueIds.map(value =>
          value.map { item =>
            QueueId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queueIds)
      .optionallyWith(
        fleetIds.map(value =>
          value.map { item =>
            FleetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fleetIds)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.SessionsStatisticsResources.ReadOnly =
    zio.aws.deadline.model.SessionsStatisticsResources.wrap(buildAwsValue())
}
object SessionsStatisticsResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SessionsStatisticsResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.SessionsStatisticsResources =
      zio.aws.deadline.model.SessionsStatisticsResources(
        queueIds.map(value => value),
        fleetIds.map(value => value)
      )
    def queueIds: Optional[List[QueueId]]
    def fleetIds: Optional[List[FleetId]]
    def getQueueIds: ZIO[Any, AwsError, List[QueueId]] =
      AwsError.unwrapOptionField("queueIds", queueIds)
    def getFleetIds: ZIO[Any, AwsError, List[FleetId]] =
      AwsError.unwrapOptionField("fleetIds", fleetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SessionsStatisticsResources
  ) extends zio.aws.deadline.model.SessionsStatisticsResources.ReadOnly {
    override val queueIds: Optional[List[QueueId]] = zio.aws.core.internal
      .optionalFromNullable(impl.queueIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.primitives.QueueId(item)
        }.toList
      )
    override val fleetIds: Optional[List[FleetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.primitives.FleetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SessionsStatisticsResources
  ): zio.aws.deadline.model.SessionsStatisticsResources.ReadOnly = new Wrapper(
    impl
  )
}
