package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  Timezone,
  SyntheticTimestamp_date_time,
  FarmId
}
import scala.jdk.CollectionConverters._
final case class StartSessionsStatisticsAggregationRequest(
    farmId: FarmId,
    resourceIds: zio.aws.deadline.model.SessionsStatisticsResources,
    startTime: SyntheticTimestamp_date_time,
    endTime: SyntheticTimestamp_date_time,
    timezone: Optional[Timezone] = Optional.Absent,
    period: Optional[zio.aws.deadline.model.Period] = Optional.Absent,
    groupBy: Iterable[zio.aws.deadline.model.UsageGroupByField],
    statistics: Iterable[zio.aws.deadline.model.UsageStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest = {
    import StartSessionsStatisticsAggregationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .resourceIds(resourceIds.buildAwsValue())
      .startTime(SyntheticTimestamp_date_time.unwrap(startTime): Instant)
      .endTime(SyntheticTimestamp_date_time.unwrap(endTime): Instant)
      .optionallyWith(
        timezone.map(value => Timezone.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .groupByWithStrings(groupBy.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.StartSessionsStatisticsAggregationRequest.ReadOnly =
    zio.aws.deadline.model.StartSessionsStatisticsAggregationRequest
      .wrap(buildAwsValue())
}
object StartSessionsStatisticsAggregationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.StartSessionsStatisticsAggregationRequest =
      zio.aws.deadline.model.StartSessionsStatisticsAggregationRequest(
        farmId,
        resourceIds.asEditable,
        startTime,
        endTime,
        timezone.map(value => value),
        period.map(value => value),
        groupBy,
        statistics
      )
    def farmId: FarmId
    def resourceIds: zio.aws.deadline.model.SessionsStatisticsResources.ReadOnly
    def startTime: SyntheticTimestamp_date_time
    def endTime: SyntheticTimestamp_date_time
    def timezone: Optional[Timezone]
    def period: Optional[zio.aws.deadline.model.Period]
    def groupBy: List[zio.aws.deadline.model.UsageGroupByField]
    def statistics: List[zio.aws.deadline.model.UsageStatistic]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getResourceIds: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.SessionsStatisticsResources.ReadOnly
    ] = ZIO.succeed(resourceIds)
    def getStartTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(endTime)
    def getTimezone: ZIO[Any, AwsError, Timezone] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getPeriod: ZIO[Any, AwsError, zio.aws.deadline.model.Period] =
      AwsError.unwrapOptionField("period", period)
    def getGroupBy
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.UsageGroupByField]] =
      ZIO.succeed(groupBy)
    def getStatistics
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.UsageStatistic]] =
      ZIO.succeed(statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest
  ) extends zio.aws.deadline.model.StartSessionsStatisticsAggregationRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val resourceIds
        : zio.aws.deadline.model.SessionsStatisticsResources.ReadOnly =
      zio.aws.deadline.model.SessionsStatisticsResources
        .wrap(impl.resourceIds())
    override val startTime: SyntheticTimestamp_date_time =
      zio.aws.deadline.model.primitives
        .SyntheticTimestamp_date_time(impl.startTime())
    override val endTime: SyntheticTimestamp_date_time =
      zio.aws.deadline.model.primitives
        .SyntheticTimestamp_date_time(impl.endTime())
    override val timezone: Optional[Timezone] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => zio.aws.deadline.model.primitives.Timezone(value))
    override val period: Optional[zio.aws.deadline.model.Period] =
      zio.aws.core.internal
        .optionalFromNullable(impl.period())
        .map(value => zio.aws.deadline.model.Period.wrap(value))
    override val groupBy: List[zio.aws.deadline.model.UsageGroupByField] = impl
      .groupBy()
      .asScala
      .map { item =>
        zio.aws.deadline.model.UsageGroupByField.wrap(item)
      }
      .toList
    override val statistics: List[zio.aws.deadline.model.UsageStatistic] = impl
      .statistics()
      .asScala
      .map { item =>
        zio.aws.deadline.model.UsageStatistic.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest
  ): zio.aws.deadline.model.StartSessionsStatisticsAggregationRequest.ReadOnly =
    new Wrapper(impl)
}
