package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.AggregationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartSessionsStatisticsAggregationResponse(
    aggregationId: AggregationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationResponse = {
    import StartSessionsStatisticsAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationResponse
      .builder()
      .aggregationId(AggregationId.unwrap(aggregationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse.ReadOnly =
    zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse
      .wrap(buildAwsValue())
}
object StartSessionsStatisticsAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse =
      zio.aws.deadline.model
        .StartSessionsStatisticsAggregationResponse(aggregationId)
    def aggregationId: AggregationId
    def getAggregationId: ZIO[Any, Nothing, AggregationId] =
      ZIO.succeed(aggregationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationResponse
  ) extends zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse.ReadOnly {
    override val aggregationId: AggregationId =
      zio.aws.deadline.model.primitives.AggregationId(impl.aggregationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationResponse
  ): zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
