package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  QueueId,
  FleetId,
  UserId,
  SyntheticTimestamp_date_time,
  InstanceType,
  LicenseProduct,
  JobName,
  JobId
}
import scala.jdk.CollectionConverters._
final case class Statistics(
    queueId: Optional[QueueId] = Optional.Absent,
    fleetId: Optional[FleetId] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    jobName: Optional[JobName] = Optional.Absent,
    userId: Optional[UserId] = Optional.Absent,
    usageType: Optional[zio.aws.deadline.model.UsageType] = Optional.Absent,
    licenseProduct: Optional[LicenseProduct] = Optional.Absent,
    instanceType: Optional[InstanceType] = Optional.Absent,
    count: zio.aws.deadline.model.primitives.Integer,
    costInUsd: zio.aws.deadline.model.Stats,
    runtimeInSeconds: zio.aws.deadline.model.Stats,
    aggregationStartTime: Optional[SyntheticTimestamp_date_time] =
      Optional.Absent,
    aggregationEndTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.Statistics = {
    import Statistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.Statistics
      .builder()
      .optionallyWith(
        queueId.map(value => QueueId.unwrap(value): java.lang.String)
      )(_.queueId)
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(usageType.map(value => value.unwrap))(_.usageType)
      .optionallyWith(
        licenseProduct.map(value =>
          LicenseProduct.unwrap(value): java.lang.String
        )
      )(_.licenseProduct)
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .count(count: Integer)
      .costInUsd(costInUsd.buildAwsValue())
      .runtimeInSeconds(runtimeInSeconds.buildAwsValue())
      .optionallyWith(
        aggregationStartTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.aggregationStartTime)
      .optionallyWith(
        aggregationEndTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.aggregationEndTime)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.Statistics.ReadOnly =
    zio.aws.deadline.model.Statistics.wrap(buildAwsValue())
}
object Statistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.Statistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.Statistics =
      zio.aws.deadline.model.Statistics(
        queueId.map(value => value),
        fleetId.map(value => value),
        jobId.map(value => value),
        jobName.map(value => value),
        userId.map(value => value),
        usageType.map(value => value),
        licenseProduct.map(value => value),
        instanceType.map(value => value),
        count,
        costInUsd.asEditable,
        runtimeInSeconds.asEditable,
        aggregationStartTime.map(value => value),
        aggregationEndTime.map(value => value)
      )
    def queueId: Optional[QueueId]
    def fleetId: Optional[FleetId]
    def jobId: Optional[JobId]
    def jobName: Optional[JobName]
    def userId: Optional[UserId]
    def usageType: Optional[zio.aws.deadline.model.UsageType]
    def licenseProduct: Optional[LicenseProduct]
    def instanceType: Optional[InstanceType]
    def count: zio.aws.deadline.model.primitives.Integer
    def costInUsd: zio.aws.deadline.model.Stats.ReadOnly
    def runtimeInSeconds: zio.aws.deadline.model.Stats.ReadOnly
    def aggregationStartTime: Optional[SyntheticTimestamp_date_time]
    def aggregationEndTime: Optional[SyntheticTimestamp_date_time]
    def getQueueId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("queueId", queueId)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getUsageType: ZIO[Any, AwsError, zio.aws.deadline.model.UsageType] =
      AwsError.unwrapOptionField("usageType", usageType)
    def getLicenseProduct: ZIO[Any, AwsError, LicenseProduct] =
      AwsError.unwrapOptionField("licenseProduct", licenseProduct)
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getCount: ZIO[Any, Nothing, zio.aws.deadline.model.primitives.Integer] =
      ZIO.succeed(count)
    def getCostInUsd: ZIO[Any, Nothing, zio.aws.deadline.model.Stats.ReadOnly] =
      ZIO.succeed(costInUsd)
    def getRuntimeInSeconds
        : ZIO[Any, Nothing, zio.aws.deadline.model.Stats.ReadOnly] =
      ZIO.succeed(runtimeInSeconds)
    def getAggregationStartTime
        : ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("aggregationStartTime", aggregationStartTime)
    def getAggregationEndTime
        : ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("aggregationEndTime", aggregationEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.Statistics
  ) extends zio.aws.deadline.model.Statistics.ReadOnly {
    override val queueId: Optional[QueueId] = zio.aws.core.internal
      .optionalFromNullable(impl.queueId())
      .map(value => zio.aws.deadline.model.primitives.QueueId(value))
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.deadline.model.primitives.FleetId(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.deadline.model.primitives.JobId(value))
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.deadline.model.primitives.JobName(value))
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.deadline.model.primitives.UserId(value))
    override val usageType: Optional[zio.aws.deadline.model.UsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageType())
        .map(value => zio.aws.deadline.model.UsageType.wrap(value))
    override val licenseProduct: Optional[LicenseProduct] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseProduct())
        .map(value => zio.aws.deadline.model.primitives.LicenseProduct(value))
    override val instanceType: Optional[InstanceType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.deadline.model.primitives.InstanceType(value))
    override val count: zio.aws.deadline.model.primitives.Integer =
      impl.count(): zio.aws.deadline.model.primitives.Integer
    override val costInUsd: zio.aws.deadline.model.Stats.ReadOnly =
      zio.aws.deadline.model.Stats.wrap(impl.costInUsd())
    override val runtimeInSeconds: zio.aws.deadline.model.Stats.ReadOnly =
      zio.aws.deadline.model.Stats.wrap(impl.runtimeInSeconds())
    override val aggregationStartTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationStartTime())
        .map(value =>
          zio.aws.deadline.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val aggregationEndTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationEndTime())
        .map(value =>
          zio.aws.deadline.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.Statistics
  ): zio.aws.deadline.model.Statistics.ReadOnly = new Wrapper(impl)
}
