package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Stats(
    min: Optional[Double] = Optional.Absent,
    max: Optional[Double] = Optional.Absent,
    avg: Optional[Double] = Optional.Absent,
    sum: Optional[Double] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.deadline.model.Stats = {
    import Stats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.Stats
      .builder()
      .optionallyWith(min.map(value => value: java.lang.Double))(_.min)
      .optionallyWith(max.map(value => value: java.lang.Double))(_.max)
      .optionallyWith(avg.map(value => value: java.lang.Double))(_.avg)
      .optionallyWith(sum.map(value => value: java.lang.Double))(_.sum)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.Stats.ReadOnly =
    zio.aws.deadline.model.Stats.wrap(buildAwsValue())
}
object Stats {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.deadline.model.Stats] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.Stats = zio.aws.deadline.model.Stats(
      min.map(value => value),
      max.map(value => value),
      avg.map(value => value),
      sum.map(value => value)
    )
    def min: Optional[Double]
    def max: Optional[Double]
    def avg: Optional[Double]
    def sum: Optional[Double]
    def getMin: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("max", max)
    def getAvg: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("avg", avg)
    def getSum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("sum", sum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.Stats
  ) extends zio.aws.deadline.model.Stats.ReadOnly {
    override val min: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: Double)
    override val max: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Double)
    override val avg: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.avg())
      .map(value => value: Double)
    override val sum: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.sum())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.Stats
  ): zio.aws.deadline.model.Stats.ReadOnly = new Wrapper(impl)
}
