package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.AmountCapabilityName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StepAmountCapability(
    name: AmountCapabilityName,
    min: Optional[Double] = Optional.Absent,
    max: Optional[Double] = Optional.Absent,
    value: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepAmountCapability = {
    import StepAmountCapability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepAmountCapability
      .builder()
      .name(AmountCapabilityName.unwrap(name): java.lang.String)
      .optionallyWith(min.map(value => value: java.lang.Double))(_.min)
      .optionallyWith(max.map(value => value: java.lang.Double))(_.max)
      .optionallyWith(value.map(value => value: java.lang.Double))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepAmountCapability.ReadOnly =
    zio.aws.deadline.model.StepAmountCapability.wrap(buildAwsValue())
}
object StepAmountCapability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepAmountCapability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepAmountCapability =
      zio.aws.deadline.model.StepAmountCapability(
        name,
        min.map(value => value),
        max.map(value => value),
        value.map(value => value)
      )
    def name: AmountCapabilityName
    def min: Optional[Double]
    def max: Optional[Double]
    def value: Optional[Double]
    def getName: ZIO[Any, Nothing, AmountCapabilityName] = ZIO.succeed(name)
    def getMin: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("max", max)
    def getValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepAmountCapability
  ) extends zio.aws.deadline.model.StepAmountCapability.ReadOnly {
    override val name: AmountCapabilityName =
      zio.aws.deadline.model.primitives.AmountCapabilityName(impl.name())
    override val min: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: Double)
    override val max: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Double)
    override val value: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepAmountCapability
  ): zio.aws.deadline.model.StepAmountCapability.ReadOnly = new Wrapper(impl)
}
