package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  AttributeCapabilityValue,
  AttributeCapabilityName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StepAttributeCapability(
    name: AttributeCapabilityName,
    anyOf: Optional[Iterable[AttributeCapabilityValue]] = Optional.Absent,
    allOf: Optional[Iterable[AttributeCapabilityValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepAttributeCapability = {
    import StepAttributeCapability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepAttributeCapability
      .builder()
      .name(AttributeCapabilityName.unwrap(name): java.lang.String)
      .optionallyWith(
        anyOf.map(value =>
          value.map { item =>
            AttributeCapabilityValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.anyOf)
      .optionallyWith(
        allOf.map(value =>
          value.map { item =>
            AttributeCapabilityValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allOf)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepAttributeCapability.ReadOnly =
    zio.aws.deadline.model.StepAttributeCapability.wrap(buildAwsValue())
}
object StepAttributeCapability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepAttributeCapability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepAttributeCapability =
      zio.aws.deadline.model.StepAttributeCapability(
        name,
        anyOf.map(value => value),
        allOf.map(value => value)
      )
    def name: AttributeCapabilityName
    def anyOf: Optional[List[AttributeCapabilityValue]]
    def allOf: Optional[List[AttributeCapabilityValue]]
    def getName: ZIO[Any, Nothing, AttributeCapabilityName] = ZIO.succeed(name)
    def getAnyOf: ZIO[Any, AwsError, List[AttributeCapabilityValue]] =
      AwsError.unwrapOptionField("anyOf", anyOf)
    def getAllOf: ZIO[Any, AwsError, List[AttributeCapabilityValue]] =
      AwsError.unwrapOptionField("allOf", allOf)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepAttributeCapability
  ) extends zio.aws.deadline.model.StepAttributeCapability.ReadOnly {
    override val name: AttributeCapabilityName =
      zio.aws.deadline.model.primitives.AttributeCapabilityName(impl.name())
    override val anyOf: Optional[List[AttributeCapabilityValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anyOf())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.primitives.AttributeCapabilityValue(item)
          }.toList
        )
    override val allOf: Optional[List[AttributeCapabilityValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allOf())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.primitives.AttributeCapabilityValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepAttributeCapability
  ): zio.aws.deadline.model.StepAttributeCapability.ReadOnly = new Wrapper(impl)
}
