package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.StepId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StepConsumer(
    stepId: StepId,
    status: zio.aws.deadline.model.DependencyConsumerResolutionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepConsumer = {
    import StepConsumer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepConsumer
      .builder()
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepConsumer.ReadOnly =
    zio.aws.deadline.model.StepConsumer.wrap(buildAwsValue())
}
object StepConsumer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepConsumer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepConsumer =
      zio.aws.deadline.model.StepConsumer(stepId, status)
    def stepId: StepId
    def status: zio.aws.deadline.model.DependencyConsumerResolutionStatus
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.DependencyConsumerResolutionStatus
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepConsumer
  ) extends zio.aws.deadline.model.StepConsumer.ReadOnly {
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val status
        : zio.aws.deadline.model.DependencyConsumerResolutionStatus =
      zio.aws.deadline.model.DependencyConsumerResolutionStatus
        .wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepConsumer
  ): zio.aws.deadline.model.StepConsumer.ReadOnly = new Wrapper(impl)
}
