package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.StepId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StepDependency(
    stepId: StepId,
    status: zio.aws.deadline.model.DependencyConsumerResolutionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepDependency = {
    import StepDependency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepDependency
      .builder()
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepDependency.ReadOnly =
    zio.aws.deadline.model.StepDependency.wrap(buildAwsValue())
}
object StepDependency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepDependency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepDependency =
      zio.aws.deadline.model.StepDependency(stepId, status)
    def stepId: StepId
    def status: zio.aws.deadline.model.DependencyConsumerResolutionStatus
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.DependencyConsumerResolutionStatus
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepDependency
  ) extends zio.aws.deadline.model.StepDependency.ReadOnly {
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val status
        : zio.aws.deadline.model.DependencyConsumerResolutionStatus =
      zio.aws.deadline.model.DependencyConsumerResolutionStatus
        .wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepDependency
  ): zio.aws.deadline.model.StepDependency.ReadOnly = new Wrapper(impl)
}
