package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{StepId, JobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StepDetailsEntity(
    jobId: JobId,
    stepId: StepId,
    schemaVersion: String,
    template: zio.aws.deadline.model.Document,
    dependencies: Iterable[StepId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepDetailsEntity = {
    import StepDetailsEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepDetailsEntity
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .schemaVersion(schemaVersion: java.lang.String)
      .template(template)
      .dependencies(dependencies.map { item =>
        StepId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepDetailsEntity.ReadOnly =
    zio.aws.deadline.model.StepDetailsEntity.wrap(buildAwsValue())
}
object StepDetailsEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepDetailsEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepDetailsEntity =
      zio.aws.deadline.model.StepDetailsEntity(
        jobId,
        stepId,
        schemaVersion,
        template,
        dependencies
      )
    def jobId: JobId
    def stepId: StepId
    def schemaVersion: String
    def template: software.amazon.awssdk.core.document.Document
    def dependencies: List[StepId]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getSchemaVersion: ZIO[Any, Nothing, String] = ZIO.succeed(schemaVersion)
    def getTemplate
        : ZIO[Any, Nothing, software.amazon.awssdk.core.document.Document] =
      ZIO.succeed(template)
    def getDependencies: ZIO[Any, Nothing, List[StepId]] =
      ZIO.succeed(dependencies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepDetailsEntity
  ) extends zio.aws.deadline.model.StepDetailsEntity.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val schemaVersion: String = impl.schemaVersion(): String
    override val template: software.amazon.awssdk.core.document.Document =
      impl.template()
    override val dependencies: List[StepId] = impl
      .dependencies()
      .asScala
      .map { item =>
        zio.aws.deadline.model.primitives.StepId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepDetailsEntity
  ): zio.aws.deadline.model.StepDetailsEntity.ReadOnly = new Wrapper(impl)
}
