package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{StepId, JobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StepDetailsError(
    jobId: JobId,
    stepId: StepId,
    code: zio.aws.deadline.model.JobEntityErrorCode,
    message: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepDetailsError = {
    import StepDetailsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepDetailsError
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .code(code.unwrap)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepDetailsError.ReadOnly =
    zio.aws.deadline.model.StepDetailsError.wrap(buildAwsValue())
}
object StepDetailsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepDetailsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepDetailsError =
      zio.aws.deadline.model.StepDetailsError(jobId, stepId, code, message)
    def jobId: JobId
    def stepId: StepId
    def code: zio.aws.deadline.model.JobEntityErrorCode
    def message: String
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getCode: ZIO[Any, Nothing, zio.aws.deadline.model.JobEntityErrorCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepDetailsError
  ) extends zio.aws.deadline.model.StepDetailsError.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val code: zio.aws.deadline.model.JobEntityErrorCode =
      zio.aws.deadline.model.JobEntityErrorCode.wrap(impl.code())
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepDetailsError
  ): zio.aws.deadline.model.StepDetailsError.ReadOnly = new Wrapper(impl)
}
