package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{StepId, JobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StepDetailsIdentifiers(jobId: JobId, stepId: StepId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepDetailsIdentifiers = {
    import StepDetailsIdentifiers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepDetailsIdentifiers
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepDetailsIdentifiers.ReadOnly =
    zio.aws.deadline.model.StepDetailsIdentifiers.wrap(buildAwsValue())
}
object StepDetailsIdentifiers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepDetailsIdentifiers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepDetailsIdentifiers =
      zio.aws.deadline.model.StepDetailsIdentifiers(jobId, stepId)
    def jobId: JobId
    def stepId: StepId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepDetailsIdentifiers
  ) extends zio.aws.deadline.model.StepDetailsIdentifiers.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepDetailsIdentifiers
  ): zio.aws.deadline.model.StepDetailsIdentifiers.ReadOnly = new Wrapper(impl)
}
