package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait StepLifecycleStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.StepLifecycleStatus
}
object StepLifecycleStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.StepLifecycleStatus
  ): zio.aws.deadline.model.StepLifecycleStatus = value match {
    case software.amazon.awssdk.services.deadline.model.StepLifecycleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.StepLifecycleStatus.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.deadline.model.StepLifecycleStatus.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.deadline.model.StepLifecycleStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.deadline.model.StepLifecycleStatus.UPDATE_SUCCEEDED =>
      val r = UPDATE_SUCCEEDED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.StepLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.StepLifecycleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_COMPLETE
      extends zio.aws.deadline.model.StepLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.StepLifecycleStatus.CREATE_COMPLETE
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.deadline.model.StepLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.StepLifecycleStatus.UPDATE_IN_PROGRESS
  }
  case object UPDATE_FAILED extends zio.aws.deadline.model.StepLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.StepLifecycleStatus.UPDATE_FAILED
  }
  case object UPDATE_SUCCEEDED
      extends zio.aws.deadline.model.StepLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.StepLifecycleStatus.UPDATE_SUCCEEDED
  }
}
