package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.StepParameterName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StepParameter(
    name: StepParameterName,
    `type`: zio.aws.deadline.model.StepParameterType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepParameter = {
    import StepParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepParameter
      .builder()
      .name(StepParameterName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepParameter.ReadOnly =
    zio.aws.deadline.model.StepParameter.wrap(buildAwsValue())
}
object StepParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepParameter =
      zio.aws.deadline.model.StepParameter(name, `type`)
    def name: StepParameterName
    def `type`: zio.aws.deadline.model.StepParameterType
    def getName: ZIO[Any, Nothing, StepParameterName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.deadline.model.StepParameterType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepParameter
  ) extends zio.aws.deadline.model.StepParameter.ReadOnly {
    override val name: StepParameterName =
      zio.aws.deadline.model.primitives.StepParameterName(impl.name())
    override val `type`: zio.aws.deadline.model.StepParameterType =
      zio.aws.deadline.model.StepParameterType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepParameter
  ): zio.aws.deadline.model.StepParameter.ReadOnly = new Wrapper(impl)
}
