package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait StepParameterType {
  def unwrap: software.amazon.awssdk.services.deadline.model.StepParameterType
}
object StepParameterType {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.StepParameterType
  ): zio.aws.deadline.model.StepParameterType = value match {
    case software.amazon.awssdk.services.deadline.model.StepParameterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.StepParameterType.INT =>
      val r = INT
      r
    case software.amazon.awssdk.services.deadline.model.StepParameterType.FLOAT =>
      val r = FLOAT
      r
    case software.amazon.awssdk.services.deadline.model.StepParameterType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.deadline.model.StepParameterType.PATH =>
      val r = PATH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.StepParameterType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepParameterType =
      software.amazon.awssdk.services.deadline.model.StepParameterType.UNKNOWN_TO_SDK_VERSION
  }
  case object INT extends zio.aws.deadline.model.StepParameterType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepParameterType =
      software.amazon.awssdk.services.deadline.model.StepParameterType.INT
  }
  case object FLOAT extends zio.aws.deadline.model.StepParameterType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepParameterType =
      software.amazon.awssdk.services.deadline.model.StepParameterType.FLOAT
  }
  case object STRING extends zio.aws.deadline.model.StepParameterType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepParameterType =
      software.amazon.awssdk.services.deadline.model.StepParameterType.STRING
  }
  case object PATH extends zio.aws.deadline.model.StepParameterType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepParameterType =
      software.amazon.awssdk.services.deadline.model.StepParameterType.PATH
  }
}
